/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.io.protostuff;

import ia.sh.io.protostuff.ByteString;
import ia.sh.io.protostuff.LinkedBuffer;
import ia.sh.io.protostuff.Output;
import ia.sh.io.protostuff.Schema;
import ia.sh.io.protostuff.StringSerializer;
import ia.sh.io.protostuff.WireFormat;
import ia.sh.io.protostuff.WriteSession;
import java.io.DataOutput;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public final class ProtobufOutput
extends WriteSession
implements Output {
    public static final int LITTLE_ENDIAN_32_SIZE = 4;
    public static final int LITTLE_ENDIAN_64_SIZE = 8;

    public ProtobufOutput(LinkedBuffer linkedBuffer) {
        super(linkedBuffer);
    }

    public ProtobufOutput(LinkedBuffer linkedBuffer, int n2) {
        super(linkedBuffer, n2);
    }

    @Override
    public ProtobufOutput clear() {
        super.clear();
        return this;
    }

    @Override
    public void writeInt32(int n2, int n3, boolean bl2) {
        this.tail = n3 < 0 ? ProtobufOutput.writeTagAndRawVarInt64(WireFormat.makeTag(n2, 0), n3, this, this.tail) : ProtobufOutput.writeTagAndRawVarInt32(WireFormat.makeTag(n2, 0), n3, this, this.tail);
    }

    @Override
    public void writeUInt32(int n2, int n3, boolean bl2) {
        this.tail = ProtobufOutput.writeTagAndRawVarInt32(WireFormat.makeTag(n2, 0), n3, this, this.tail);
    }

    @Override
    public void writeSInt32(int n2, int n3, boolean bl2) {
        this.tail = ProtobufOutput.writeTagAndRawVarInt32(WireFormat.makeTag(n2, 0), ProtobufOutput.encodeZigZag32(n3), this, this.tail);
    }

    @Override
    public void writeFixed32(int n2, int n3, boolean bl2) {
        this.tail = ProtobufOutput.writeTagAndRawLittleEndian32(WireFormat.makeTag(n2, 5), n3, this, this.tail);
    }

    @Override
    public void writeSFixed32(int n2, int n3, boolean bl2) {
        this.tail = ProtobufOutput.writeTagAndRawLittleEndian32(WireFormat.makeTag(n2, 5), n3, this, this.tail);
    }

    @Override
    public void writeInt64(int n2, long l2, boolean bl2) {
        this.tail = ProtobufOutput.writeTagAndRawVarInt64(WireFormat.makeTag(n2, 0), l2, this, this.tail);
    }

    @Override
    public void writeUInt64(int n2, long l2, boolean bl2) {
        this.tail = ProtobufOutput.writeTagAndRawVarInt64(WireFormat.makeTag(n2, 0), l2, this, this.tail);
    }

    @Override
    public void writeSInt64(int n2, long l2, boolean bl2) {
        this.tail = ProtobufOutput.writeTagAndRawVarInt64(WireFormat.makeTag(n2, 0), ProtobufOutput.encodeZigZag64(l2), this, this.tail);
    }

    @Override
    public void writeFixed64(int n2, long l2, boolean bl2) {
        this.tail = ProtobufOutput.writeTagAndRawLittleEndian64(WireFormat.makeTag(n2, 1), l2, this, this.tail);
    }

    @Override
    public void writeSFixed64(int n2, long l2, boolean bl2) {
        this.tail = ProtobufOutput.writeTagAndRawLittleEndian64(WireFormat.makeTag(n2, 1), l2, this, this.tail);
    }

    @Override
    public void writeFloat(int n2, float f2, boolean bl2) {
        this.tail = ProtobufOutput.writeTagAndRawLittleEndian32(WireFormat.makeTag(n2, 5), Float.floatToRawIntBits(f2), this, this.tail);
    }

    @Override
    public void writeDouble(int n2, double d2, boolean bl2) {
        this.tail = ProtobufOutput.writeTagAndRawLittleEndian64(WireFormat.makeTag(n2, 1), Double.doubleToRawLongBits(d2), this, this.tail);
    }

    @Override
    public void writeBool(int n2, boolean bl2, boolean bl3) {
        this.tail = ProtobufOutput.writeTagAndRawVarInt32(WireFormat.makeTag(n2, 0), bl2 ? 1 : 0, this, this.tail);
    }

    @Override
    public void writeEnum(int n2, int n3, boolean bl2) {
        this.writeInt32(n2, n3, bl2);
    }

    @Override
    public void writeString(int n2, CharSequence charSequence, boolean bl2) {
        this.tail = StringSerializer.writeUTF8VarDelimited(charSequence, this, ProtobufOutput.writeRawVarInt32(WireFormat.makeTag(n2, 2), this, this.tail));
    }

    @Override
    public void writeBytes(int n2, ByteString byteString, boolean bl2) {
        this.writeByteArray(n2, byteString.getBytes(), bl2);
    }

    @Override
    public void writeByteArray(int n2, byte[] byArray, boolean bl2) {
        this.tail = ProtobufOutput.writeTagAndByteArray(WireFormat.makeTag(n2, 2), byArray, 0, byArray.length, this, this.tail);
    }

    @Override
    public void writeByteRange(boolean bl2, int n2, byte[] byArray, int n3, int n4, boolean bl3) {
        this.tail = ProtobufOutput.writeTagAndByteArray(WireFormat.makeTag(n2, 2), byArray, n3, n4, this, this.tail);
    }

    @Override
    public void writeObject(int n2, Object object, Schema schema, boolean bl2) {
        LinkedBuffer linkedBuffer;
        if (n2 < 16 && this.tail.offset != this.tail.buffer.length) {
            linkedBuffer = this.tail;
            ++this.size;
            linkedBuffer.buffer[linkedBuffer.offset++] = (byte)WireFormat.makeTag(n2, 2);
        } else {
            this.tail = linkedBuffer = ProtobufOutput.writeRawVarInt32(WireFormat.makeTag(n2, 2), this, this.tail);
        }
        int n3 = this.tail.offset;
        int n4 = this.size++;
        if (n3 == linkedBuffer.buffer.length) {
            LinkedBuffer linkedBuffer2;
            this.tail = linkedBuffer2 = new LinkedBuffer(this.nextBufferSize);
            schema.writeTo(this, object);
            int n5 = this.size - n4;
            byte[] byArray = new byte[ProtobufOutput.computeRawVarint32Size(n5)];
            ProtobufOutput.writeRawVarInt32(n5, byArray, 0);
            this.size += byArray.length;
            new LinkedBuffer((byte[])byArray, (int)0, (int)byArray.length, (LinkedBuffer)linkedBuffer).next = linkedBuffer2;
            return;
        }
        ++linkedBuffer.offset;
        schema.writeTo(this, object);
        int n6 = this.size - n4 - 1;
        if (n6 < 128) {
            linkedBuffer.buffer[n3] = (byte)n6;
            return;
        }
        LinkedBuffer linkedBuffer3 = new LinkedBuffer(linkedBuffer.buffer, n3 + 1, linkedBuffer.offset);
        if (linkedBuffer == this.tail) {
            this.tail = linkedBuffer3;
        } else {
            linkedBuffer3.next = linkedBuffer.next;
        }
        linkedBuffer.offset = n3;
        byte[] byArray = new byte[ProtobufOutput.computeRawVarint32Size(n6)];
        ProtobufOutput.writeRawVarInt32(n6, byArray, 0);
        this.size += byArray.length - 1;
        new LinkedBuffer((byte[])byArray, (int)0, (int)byArray.length, (LinkedBuffer)linkedBuffer).next = linkedBuffer3;
    }

    public static LinkedBuffer writeRawVarInt32(int n2, WriteSession writeSession, LinkedBuffer linkedBuffer) {
        int n3 = ProtobufOutput.computeRawVarint32Size(n2);
        if (linkedBuffer.offset + n3 > linkedBuffer.buffer.length) {
            linkedBuffer = new LinkedBuffer(writeSession.nextBufferSize, linkedBuffer);
        }
        byte[] byArray = linkedBuffer.buffer;
        int n4 = linkedBuffer.offset;
        linkedBuffer.offset += n3;
        writeSession.size += n3;
        if (n3 == 1) {
            byArray[n4] = (byte)n2;
        } else {
            int n5 = 0;
            int n6 = n3 - 1;
            while (n5 < n6) {
                byArray[n4++] = (byte)(n2 & 0x7F | 0x80);
                ++n5;
                n2 >>>= 7;
            }
            byArray[n4] = (byte)n2;
        }
        return linkedBuffer;
    }

    public static LinkedBuffer writeTagAndLinkedBuffer(int n2, LinkedBuffer linkedBuffer, WriteSession writeSession, LinkedBuffer linkedBuffer2) {
        int n3 = linkedBuffer.offset - linkedBuffer.start;
        if (n3 == 0) {
            return ProtobufOutput.writeTagAndRawVarInt32(n2, n3, writeSession, linkedBuffer2);
        }
        linkedBuffer2 = ProtobufOutput.writeTagAndRawVarInt32(n2, n3, writeSession, linkedBuffer2);
        linkedBuffer2.next = linkedBuffer;
        int n4 = linkedBuffer2.buffer.length - linkedBuffer2.offset;
        return n4 == 0 ? new LinkedBuffer(writeSession.nextBufferSize, linkedBuffer) : new LinkedBuffer(linkedBuffer2, linkedBuffer);
    }

    public static LinkedBuffer writeTagAndByteArray(int n2, byte[] byArray, int n3, int n4, WriteSession writeSession, LinkedBuffer linkedBuffer) {
        if (n4 == 0) {
            return ProtobufOutput.writeTagAndRawVarInt32(n2, n4, writeSession, linkedBuffer);
        }
        linkedBuffer = ProtobufOutput.writeTagAndRawVarInt32(n2, n4, writeSession, linkedBuffer);
        writeSession.size += n4;
        int n5 = linkedBuffer.buffer.length - linkedBuffer.offset;
        if (n4 > n5) {
            if (n5 + writeSession.nextBufferSize < n4) {
                if (n5 == 0) {
                    return new LinkedBuffer(writeSession.nextBufferSize, new LinkedBuffer(byArray, n3, n3 + n4, linkedBuffer));
                }
                return new LinkedBuffer(linkedBuffer, new LinkedBuffer(byArray, n3, n3 + n4, linkedBuffer));
            }
            System.arraycopy(byArray, n3, linkedBuffer.buffer, linkedBuffer.offset, n5);
            linkedBuffer.offset += n5;
            linkedBuffer = new LinkedBuffer(writeSession.nextBufferSize, linkedBuffer);
            int n6 = n4 - n5;
            System.arraycopy(byArray, n3 + n5, linkedBuffer.buffer, 0, n6);
            linkedBuffer.offset += n6;
            return linkedBuffer;
        }
        System.arraycopy(byArray, n3, linkedBuffer.buffer, linkedBuffer.offset, n4);
        linkedBuffer.offset += n4;
        return linkedBuffer;
    }

    public static LinkedBuffer writeTagAndRawVarInt32(int n2, int n3, WriteSession writeSession, LinkedBuffer linkedBuffer) {
        int n4;
        int n5;
        int n6;
        int n7 = ProtobufOutput.computeRawVarint32Size(n2);
        int n8 = n7 + (n6 = ProtobufOutput.computeRawVarint32Size(n3));
        if (linkedBuffer.offset + n8 > linkedBuffer.buffer.length) {
            linkedBuffer = new LinkedBuffer(writeSession.nextBufferSize, linkedBuffer);
        }
        byte[] byArray = linkedBuffer.buffer;
        int n9 = linkedBuffer.offset;
        linkedBuffer.offset += n8;
        writeSession.size += n8;
        if (n7 == 1) {
            byArray[n9++] = (byte)n2;
        } else {
            n5 = 0;
            n4 = n7 - 1;
            while (n5 < n4) {
                byArray[n9++] = (byte)(n2 & 0x7F | 0x80);
                ++n5;
                n2 >>>= 7;
            }
            byArray[n9++] = (byte)n2;
        }
        if (n6 == 1) {
            byArray[n9] = (byte)n3;
        } else {
            n5 = 0;
            n4 = n6 - 1;
            while (n5 < n4) {
                byArray[n9++] = (byte)(n3 & 0x7F | 0x80);
                ++n5;
                n3 >>>= 7;
            }
            byArray[n9] = (byte)n3;
        }
        return linkedBuffer;
    }

    public static LinkedBuffer writeTagAndRawVarInt64(int n2, long l2, WriteSession writeSession, LinkedBuffer linkedBuffer) {
        int n3;
        int n4;
        int n5;
        int n6 = ProtobufOutput.computeRawVarint32Size(n2);
        int n7 = n6 + (n5 = ProtobufOutput.computeRawVarint64Size(l2));
        if (linkedBuffer.offset + n7 > linkedBuffer.buffer.length) {
            linkedBuffer = new LinkedBuffer(writeSession.nextBufferSize, linkedBuffer);
        }
        byte[] byArray = linkedBuffer.buffer;
        int n8 = linkedBuffer.offset;
        linkedBuffer.offset += n7;
        writeSession.size += n7;
        if (n6 == 1) {
            byArray[n8++] = (byte)n2;
        } else {
            n4 = 0;
            n3 = n6 - 1;
            while (n4 < n3) {
                byArray[n8++] = (byte)(n2 & 0x7F | 0x80);
                ++n4;
                n2 >>>= 7;
            }
            byArray[n8++] = (byte)n2;
        }
        if (n5 == 1) {
            byArray[n8] = (byte)l2;
        } else {
            n4 = 0;
            n3 = n5 - 1;
            while (n4 < n3) {
                byArray[n8++] = (byte)((int)l2 & 0x7F | 0x80);
                ++n4;
                l2 >>>= 7;
            }
            byArray[n8] = (byte)l2;
        }
        return linkedBuffer;
    }

    public static LinkedBuffer writeTagAndRawLittleEndian32(int n2, int n3, WriteSession writeSession, LinkedBuffer linkedBuffer) {
        int n4 = ProtobufOutput.computeRawVarint32Size(n2);
        int n5 = n4 + 4;
        if (linkedBuffer.offset + n5 > linkedBuffer.buffer.length) {
            linkedBuffer = new LinkedBuffer(writeSession.nextBufferSize, linkedBuffer);
        }
        byte[] byArray = linkedBuffer.buffer;
        int n6 = linkedBuffer.offset;
        linkedBuffer.offset += n5;
        writeSession.size += n5;
        if (n4 == 1) {
            byArray[n6++] = (byte)n2;
        } else {
            int n7 = 0;
            int n8 = n4 - 1;
            while (n7 < n8) {
                byArray[n6++] = (byte)(n2 & 0x7F | 0x80);
                ++n7;
                n2 >>>= 7;
            }
            byArray[n6++] = (byte)n2;
        }
        ProtobufOutput.writeRawLittleEndian32(n3, byArray, n6);
        return linkedBuffer;
    }

    public static LinkedBuffer writeTagAndRawLittleEndian64(int n2, long l2, WriteSession writeSession, LinkedBuffer linkedBuffer) {
        int n3 = ProtobufOutput.computeRawVarint32Size(n2);
        int n4 = n3 + 8;
        if (linkedBuffer.offset + n4 > linkedBuffer.buffer.length) {
            linkedBuffer = new LinkedBuffer(writeSession.nextBufferSize, linkedBuffer);
        }
        byte[] byArray = linkedBuffer.buffer;
        int n5 = linkedBuffer.offset;
        linkedBuffer.offset += n4;
        writeSession.size += n4;
        if (n3 == 1) {
            byArray[n5++] = (byte)n2;
        } else {
            int n6 = 0;
            int n7 = n3 - 1;
            while (n6 < n7) {
                byArray[n5++] = (byte)(n2 & 0x7F | 0x80);
                ++n6;
                n2 >>>= 7;
            }
            byArray[n5++] = (byte)n2;
        }
        ProtobufOutput.writeRawLittleEndian64(l2, byArray, n5);
        return linkedBuffer;
    }

    public static void writeRawVarInt32(int n2, byte[] byArray, int n3) {
        while (true) {
            if ((n2 & 0xFFFFFF80) == 0) {
                byArray[n3] = (byte)n2;
                return;
            }
            byArray[n3++] = (byte)(n2 & 0x7F | 0x80);
            n2 >>>= 7;
        }
    }

    public static void writeRawVarInt32Bytes(OutputStream outputStream, int n2) {
        while (true) {
            if ((n2 & 0xFFFFFF80) == 0) {
                outputStream.write(n2);
                return;
            }
            outputStream.write(n2 & 0x7F | 0x80);
            n2 >>>= 7;
        }
    }

    public static void writeRawVarInt32Bytes(DataOutput dataOutput, int n2) {
        while (true) {
            if ((n2 & 0xFFFFFF80) == 0) {
                dataOutput.write(n2);
                return;
            }
            dataOutput.write(n2 & 0x7F | 0x80);
            n2 >>>= 7;
        }
    }

    public static byte[] getTagAndRawVarInt32Bytes(int n2, int n3) {
        int n4;
        int n5;
        int n6 = ProtobufOutput.computeRawVarint32Size(n2);
        int n7 = ProtobufOutput.computeRawVarint32Size(n3);
        int n8 = 0;
        byte[] byArray = new byte[n6 + n7];
        if (n6 == 1) {
            byArray[n8++] = (byte)n2;
        } else {
            n5 = 0;
            n4 = n6 - 1;
            while (n5 < n4) {
                byArray[n8++] = (byte)(n2 & 0x7F | 0x80);
                ++n5;
                n2 >>>= 7;
            }
            byArray[n8++] = (byte)n2;
        }
        if (n7 == 1) {
            byArray[n8] = (byte)n3;
        } else {
            n5 = 0;
            n4 = n7 - 1;
            while (n5 < n4) {
                byArray[n8++] = (byte)(n3 & 0x7F | 0x80);
                ++n5;
                n3 >>>= 7;
            }
            byArray[n8] = (byte)n3;
        }
        return byArray;
    }

    public static byte[] getTagAndRawVarInt64Bytes(int n2, long l2) {
        int n3;
        int n4;
        int n5 = ProtobufOutput.computeRawVarint32Size(n2);
        int n6 = ProtobufOutput.computeRawVarint64Size(l2);
        int n7 = 0;
        byte[] byArray = new byte[n5 + n6];
        if (n5 == 1) {
            byArray[n7++] = (byte)n2;
        } else {
            n4 = 0;
            n3 = n5 - 1;
            while (n4 < n3) {
                byArray[n7++] = (byte)(n2 & 0x7F | 0x80);
                ++n4;
                n2 >>>= 7;
            }
            byArray[n7++] = (byte)n2;
        }
        if (n6 == 1) {
            byArray[n7] = (byte)l2;
        } else {
            n4 = 0;
            n3 = n6 - 1;
            while (n4 < n3) {
                byArray[n7++] = (byte)((int)l2 & 0x7F | 0x80);
                ++n4;
                l2 >>>= 7;
            }
            byArray[n7] = (byte)l2;
        }
        return byArray;
    }

    public static byte[] getTagAndRawLittleEndian32Bytes(int n2, int n3) {
        int n4 = ProtobufOutput.computeRawVarint32Size(n2);
        int n5 = 0;
        byte[] byArray = new byte[n4 + 4];
        if (n4 == 1) {
            byArray[n5++] = (byte)n2;
        } else {
            int n6 = 0;
            int n7 = n4 - 1;
            while (n6 < n7) {
                byArray[n5++] = (byte)(n2 & 0x7F | 0x80);
                ++n6;
                n2 >>>= 7;
            }
            byArray[n5++] = (byte)n2;
        }
        ProtobufOutput.writeRawLittleEndian32(n3, byArray, n5);
        return byArray;
    }

    public static byte[] getTagAndRawLittleEndian64Bytes(int n2, long l2) {
        int n3 = ProtobufOutput.computeRawVarint32Size(n2);
        int n4 = 0;
        byte[] byArray = new byte[n3 + 8];
        if (n3 == 1) {
            byArray[n4++] = (byte)n2;
        } else {
            int n5 = 0;
            int n6 = n3 - 1;
            while (n5 < n6) {
                byArray[n4++] = (byte)(n2 & 0x7F | 0x80);
                ++n5;
                n2 >>>= 7;
            }
            byArray[n4++] = (byte)n2;
        }
        ProtobufOutput.writeRawLittleEndian64(l2, byArray, n4);
        return byArray;
    }

    public static int writeRawLittleEndian32(int n2, byte[] byArray, int n3) {
        if (byArray.length - n3 < 4) {
            throw new IllegalArgumentException("buffer capacity not enough.");
        }
        byArray[n3++] = (byte)(n2 & 0xFF);
        byArray[n3++] = (byte)(n2 >> 8 & 0xFF);
        byArray[n3++] = (byte)(n2 >> 16 & 0xFF);
        byArray[n3] = (byte)(n2 >> 24 & 0xFF);
        return 4;
    }

    public static int writeRawLittleEndian64(long l2, byte[] byArray, int n2) {
        if (byArray.length - n2 < 8) {
            throw new IllegalArgumentException("buffer capacity not enough.");
        }
        byArray[n2++] = (byte)(l2 & 0xFFL);
        byArray[n2++] = (byte)(l2 >> 8 & 0xFFL);
        byArray[n2++] = (byte)(l2 >> 16 & 0xFFL);
        byArray[n2++] = (byte)(l2 >> 24 & 0xFFL);
        byArray[n2++] = (byte)(l2 >> 32 & 0xFFL);
        byArray[n2++] = (byte)(l2 >> 40 & 0xFFL);
        byArray[n2++] = (byte)(l2 >> 48 & 0xFFL);
        byArray[n2] = (byte)(l2 >> 56 & 0xFFL);
        return 8;
    }

    public static byte[] getRawVarInt32Bytes(int n2) {
        int n3 = ProtobufOutput.computeRawVarint32Size(n2);
        if (n3 == 1) {
            return new byte[]{(byte)n2};
        }
        int n4 = 0;
        byte[] byArray = new byte[n3];
        int n5 = 0;
        int n6 = n3 - 1;
        while (n5 < n6) {
            byArray[n4++] = (byte)(n2 & 0x7F | 0x80);
            ++n5;
            n2 >>>= 7;
        }
        byArray[n4] = (byte)n2;
        return byArray;
    }

    public static int computeRawVarint32Size(int n2) {
        if ((n2 & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n2 & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n2 & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n2 & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public static int computeRawVarint64Size(long l2) {
        if ((l2 & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if ((l2 & 0xFFFFFFFFFFFFC000L) == 0L) {
            return 2;
        }
        if ((l2 & 0xFFFFFFFFFFE00000L) == 0L) {
            return 3;
        }
        if ((l2 & 0xFFFFFFFFF0000000L) == 0L) {
            return 4;
        }
        if ((l2 & 0xFFFFFFF800000000L) == 0L) {
            return 5;
        }
        if ((l2 & 0xFFFFFC0000000000L) == 0L) {
            return 6;
        }
        if ((l2 & 0xFFFE000000000000L) == 0L) {
            return 7;
        }
        if ((l2 & 0xFF00000000000000L) == 0L) {
            return 8;
        }
        if ((l2 & Long.MIN_VALUE) == 0L) {
            return 9;
        }
        return 10;
    }

    public static int encodeZigZag32(int n2) {
        return n2 << 1 ^ n2 >> 31;
    }

    public static long encodeZigZag64(long l2) {
        return l2 << 1 ^ l2 >> 63;
    }

    @Override
    public void writeBytes(int n2, ByteBuffer byteBuffer, boolean bl2) {
        this.writeByteRange(false, n2, byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining(), bl2);
    }
}

