/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.net.minidev.json.writer;

import ia.sh.net.minidev.json.JSONArray;
import ia.sh.net.minidev.json.JSONAware;
import ia.sh.net.minidev.json.JSONAwareEx;
import ia.sh.net.minidev.json.JSONObject;
import ia.sh.net.minidev.json.writer.ArraysMapper;
import ia.sh.net.minidev.json.writer.ArraysMapper$GenericMapper;
import ia.sh.net.minidev.json.writer.BeansMapper;
import ia.sh.net.minidev.json.writer.BeansMapper$Bean;
import ia.sh.net.minidev.json.writer.CollectionMapper$ListClass;
import ia.sh.net.minidev.json.writer.CollectionMapper$ListType;
import ia.sh.net.minidev.json.writer.CollectionMapper$MapClass;
import ia.sh.net.minidev.json.writer.CollectionMapper$MapType;
import ia.sh.net.minidev.json.writer.DefaultMapper;
import ia.sh.net.minidev.json.writer.DefaultMapperCollection;
import ia.sh.net.minidev.json.writer.DefaultMapperOrdered;
import ia.sh.net.minidev.json.writer.JsonReaderI;
import ia.sh.net.minidev.json.writer.MapperRemapped;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class JsonReader {
    private final ConcurrentHashMap cache = new ConcurrentHashMap(100);
    public JsonReaderI DEFAULT;
    public JsonReaderI DEFAULT_ORDERED;

    public JsonReader() {
        this.cache.put(Date.class, BeansMapper.MAPPER_DATE);
        this.cache.put(int[].class, ArraysMapper.MAPPER_PRIM_INT);
        this.cache.put(Integer[].class, ArraysMapper.MAPPER_INT);
        this.cache.put(short[].class, ArraysMapper.MAPPER_PRIM_INT);
        this.cache.put(Short[].class, ArraysMapper.MAPPER_INT);
        this.cache.put(long[].class, ArraysMapper.MAPPER_PRIM_LONG);
        this.cache.put(Long[].class, ArraysMapper.MAPPER_LONG);
        this.cache.put(byte[].class, ArraysMapper.MAPPER_PRIM_BYTE);
        this.cache.put(Byte[].class, ArraysMapper.MAPPER_BYTE);
        this.cache.put(char[].class, ArraysMapper.MAPPER_PRIM_CHAR);
        this.cache.put(Character[].class, ArraysMapper.MAPPER_CHAR);
        this.cache.put(float[].class, ArraysMapper.MAPPER_PRIM_FLOAT);
        this.cache.put(Float[].class, ArraysMapper.MAPPER_FLOAT);
        this.cache.put(double[].class, ArraysMapper.MAPPER_PRIM_DOUBLE);
        this.cache.put(Double[].class, ArraysMapper.MAPPER_DOUBLE);
        this.cache.put(boolean[].class, ArraysMapper.MAPPER_PRIM_BOOL);
        this.cache.put(Boolean[].class, ArraysMapper.MAPPER_BOOL);
        this.DEFAULT = new DefaultMapper(this);
        this.DEFAULT_ORDERED = new DefaultMapperOrdered(this);
        this.cache.put(JSONAwareEx.class, this.DEFAULT);
        this.cache.put(JSONAware.class, this.DEFAULT);
        this.cache.put(JSONArray.class, this.DEFAULT);
        this.cache.put(JSONObject.class, this.DEFAULT);
    }

    public void remapField(Class clazz, String string, String string2) {
        JsonReaderI jsonReaderI = this.getMapper(clazz);
        if (!(jsonReaderI instanceof MapperRemapped)) {
            jsonReaderI = new MapperRemapped(jsonReaderI);
            this.registerReader(clazz, jsonReaderI);
        }
        ((MapperRemapped)jsonReaderI).renameField(string, string2);
    }

    public void registerReader(Class clazz, JsonReaderI jsonReaderI) {
        this.cache.put(clazz, jsonReaderI);
    }

    public JsonReaderI getMapper(Type type) {
        if (type instanceof ParameterizedType) {
            return this.getMapper((ParameterizedType)type);
        }
        return this.getMapper((Class)type);
    }

    public JsonReaderI getMapper(Class clazz) {
        JsonReaderI jsonReaderI = (JsonReaderI)this.cache.get(clazz);
        if (jsonReaderI != null) {
            return jsonReaderI;
        }
        if (clazz instanceof Class) {
            if (Map.class.isAssignableFrom(clazz)) {
                jsonReaderI = new DefaultMapperCollection(this, clazz);
            } else if (List.class.isAssignableFrom(clazz)) {
                jsonReaderI = new DefaultMapperCollection(this, clazz);
            }
            if (jsonReaderI != null) {
                this.cache.put(clazz, jsonReaderI);
                return jsonReaderI;
            }
        }
        jsonReaderI = clazz.isArray() ? new ArraysMapper$GenericMapper(this, clazz) : (List.class.isAssignableFrom(clazz) ? new CollectionMapper$ListClass(this, clazz) : (Map.class.isAssignableFrom(clazz) ? new CollectionMapper$MapClass(this, clazz) : new BeansMapper$Bean(this, clazz)));
        this.cache.putIfAbsent(clazz, jsonReaderI);
        return jsonReaderI;
    }

    public JsonReaderI getMapper(ParameterizedType parameterizedType) {
        JsonReaderI jsonReaderI = (JsonReaderI)this.cache.get(parameterizedType);
        if (jsonReaderI != null) {
            return jsonReaderI;
        }
        Class clazz = (Class)parameterizedType.getRawType();
        if (List.class.isAssignableFrom(clazz)) {
            jsonReaderI = new CollectionMapper$ListType(this, parameterizedType);
        } else if (Map.class.isAssignableFrom(clazz)) {
            jsonReaderI = new CollectionMapper$MapType(this, parameterizedType);
        }
        this.cache.putIfAbsent(parameterizedType, jsonReaderI);
        return jsonReaderI;
    }
}

