/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.org.apache.commons.math3.distribution;

import ia.sh.org.apache.commons.math3.distribution.AbstractIntegerDistribution;
import ia.sh.org.apache.commons.math3.distribution.SaddlePointExpansion;
import ia.sh.org.apache.commons.math3.exception.NotPositiveException;
import ia.sh.org.apache.commons.math3.exception.OutOfRangeException;
import ia.sh.org.apache.commons.math3.exception.util.Localizable;
import ia.sh.org.apache.commons.math3.exception.util.LocalizedFormats;
import ia.sh.org.apache.commons.math3.random.RandomGenerator;
import ia.sh.org.apache.commons.math3.random.Well19937c;
import ia.sh.org.apache.commons.math3.special.Beta;
import ia.sh.org.apache.commons.math3.util.FastMath;

public class BinomialDistribution
extends AbstractIntegerDistribution {
    private static final long serialVersionUID = 6751309484392813623L;
    private final int numberOfTrials;
    private final double probabilityOfSuccess;

    public BinomialDistribution(int n2, double d2) {
        this(new Well19937c(), n2, d2);
    }

    public BinomialDistribution(RandomGenerator randomGenerator, int n2, double d2) {
        super(randomGenerator);
        if (n2 < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.NUMBER_OF_TRIALS, n2);
        }
        if (d2 < 0.0 || d2 > 1.0) {
            throw new OutOfRangeException(d2, (Number)0, 1);
        }
        this.probabilityOfSuccess = d2;
        this.numberOfTrials = n2;
    }

    public int getNumberOfTrials() {
        return this.numberOfTrials;
    }

    public double getProbabilityOfSuccess() {
        return this.probabilityOfSuccess;
    }

    public double probability(int n2) {
        double d2 = this.logProbability(n2);
        return d2 == Double.NEGATIVE_INFINITY ? 0.0 : FastMath.exp(d2);
    }

    public double logProbability(int n2) {
        if (this.numberOfTrials == 0) {
            return n2 == 0 ? 0.0 : Double.NEGATIVE_INFINITY;
        }
        double d2 = n2 < 0 || n2 > this.numberOfTrials ? Double.NEGATIVE_INFINITY : SaddlePointExpansion.logBinomialProbability(n2, this.numberOfTrials, this.probabilityOfSuccess, 1.0 - this.probabilityOfSuccess);
        return d2;
    }

    public double cumulativeProbability(int n2) {
        double d2 = n2 < 0 ? 0.0 : (n2 >= this.numberOfTrials ? 1.0 : 1.0 - Beta.regularizedBeta(this.probabilityOfSuccess, (double)n2 + 1.0, this.numberOfTrials - n2));
        return d2;
    }

    public double getNumericalMean() {
        return (double)this.numberOfTrials * this.probabilityOfSuccess;
    }

    public double getNumericalVariance() {
        double d2 = this.probabilityOfSuccess;
        return (double)this.numberOfTrials * d2 * (1.0 - d2);
    }

    public int getSupportLowerBound() {
        return this.probabilityOfSuccess < 1.0 ? 0 : this.numberOfTrials;
    }

    public int getSupportUpperBound() {
        return this.probabilityOfSuccess > 0.0 ? this.numberOfTrials : 0;
    }

    public boolean isSupportConnected() {
        return true;
    }
}

