/*
 * Decompiled with CFR 0.152.
 */
package me.casperge.realisticseasons.api;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.conditions.IEntityCondition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.casperge.realisticseasons.RealisticSeasons;
import me.casperge.realisticseasons.season.Season;
import org.bukkit.Bukkit;
import org.bukkit.World;

public class SeasonCondition
implements IEntityCondition {
    private RealisticSeasons main;
    private List<Season> seasons;
    private List<Season> allSeasons = Arrays.asList(Season.WINTER, Season.SUMMER, Season.FALL, Season.SPRING);

    public SeasonCondition(MythicLineConfig mythicLineConfig, RealisticSeasons realisticSeasons) {
        this.main = realisticSeasons;
        String string = mythicLineConfig.getString(new String[]{"season", "s"});
        if (string == null) {
            return;
        }
        String[] stringArray = string.split(",");
        ArrayList<Season> arrayList = new ArrayList<Season>();
        for (Season season : Season.values()) {
            for (String string2 : stringArray) {
                if (!string2.trim().equalsIgnoreCase(season.getConfigName())) continue;
                arrayList.add(season);
            }
        }
        if (arrayList.isEmpty()) {
            Bukkit.getLogger().severe("[RealisticSeasons] Could not load MythicMobs condition: season(s) named " + string + " not found.");
            return;
        }
        this.seasons = arrayList;
    }

    public boolean check(AbstractEntity abstractEntity) {
        if (this.seasons == null) {
            return false;
        }
        if (abstractEntity == null) {
            int n = 0;
            Season season = null;
            for (World object : this.main.getSeasonManager().worldData.keySet()) {
                if (!this.allSeasons.contains((Object)this.main.getSeasonManager().worldData.get(object))) continue;
                ++n;
                season = this.main.getSeasonManager().worldData.get(object);
            }
            if (n == 1 || n >= 1 && this.main.getSettings().syncedWorlds.size() > 1) {
                for (Season season2 : this.seasons) {
                    if (season2 != season) continue;
                    return true;
                }
            }
            return false;
        }
        World world = Bukkit.getWorld((String)abstractEntity.getLocation().getWorld().getName());
        if (world == null) {
            return false;
        }
        World.Environment environment = world.getEnvironment();
        if (environment.equals((Object)World.Environment.THE_END) || environment.equals((Object)World.Environment.NETHER)) {
            return true;
        }
        Season season = this.main.getSeasonManager().getSeason(world);
        for (Season season3 : this.seasons) {
            if (season3 != season) continue;
            return true;
        }
        return false;
    }
}

