/*
 * Decompiled with CFR 0.152.
 */
package me.casperge.realisticseasons.api;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.EnumFlag;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.IntegerFlag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.flags.registry.FlagConflictException;
import com.sk89q.worldguard.protection.flags.registry.FlagRegistry;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedCuboidRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import me.casperge.realisticseasons.RealisticSeasons;
import me.casperge.realisticseasons.api.WGSeason;
import me.casperge.realisticseasons.season.Season;
import org.bukkit.World;

public class WGuard {
    private static StateFlag SEASON_EFFECTS;
    private static StateFlag BLOCK_CHANGES;
    private static StateFlag MOB_SPAWNING;
    private static EnumFlag<WGSeason> SEASON_FLAG;
    private static IntegerFlag TEMPERATURE;
    private static IntegerFlag TEMPERATUREMODIFIER;
    private RealisticSeasons main;

    public WGuard(RealisticSeasons realisticSeasons) {
        this.main = realisticSeasons;
        this.registerFlags();
    }

    public void registerFlags() {
        block8: {
            Flag flag;
            StateFlag stateFlag;
            FlagRegistry flagRegistry;
            block7: {
                block6: {
                    flagRegistry = WorldGuard.getInstance().getFlagRegistry();
                    EnumFlag enumFlag = new EnumFlag("permanent-season", WGSeason.class);
                    flagRegistry.register((Flag)enumFlag);
                    SEASON_FLAG = enumFlag;
                    IntegerFlag integerFlag = new IntegerFlag("permanent-temperature");
                    flagRegistry.register((Flag)integerFlag);
                    TEMPERATURE = integerFlag;
                    IntegerFlag integerFlag2 = new IntegerFlag("temperature-modifier");
                    flagRegistry.register((Flag)integerFlag2);
                    TEMPERATUREMODIFIER = integerFlag2;
                    try {
                        stateFlag = new StateFlag("season-effects", true);
                        flagRegistry.register((Flag)stateFlag);
                        SEASON_EFFECTS = stateFlag;
                    }
                    catch (FlagConflictException flagConflictException) {
                        flag = flagRegistry.get("season-effects");
                        if (!(flag instanceof StateFlag)) break block6;
                        SEASON_EFFECTS = (StateFlag)flag;
                    }
                }
                try {
                    stateFlag = new StateFlag("season-block-changes", true);
                    flagRegistry.register((Flag)stateFlag);
                    BLOCK_CHANGES = stateFlag;
                }
                catch (FlagConflictException flagConflictException) {
                    flag = flagRegistry.get("season-block-changes");
                    if (!(flag instanceof StateFlag)) break block7;
                    BLOCK_CHANGES = (StateFlag)flag;
                }
            }
            try {
                stateFlag = new StateFlag("season-mob-spawning", true);
                flagRegistry.register((Flag)stateFlag);
                MOB_SPAWNING = stateFlag;
            }
            catch (FlagConflictException flagConflictException) {
                flag = flagRegistry.get("season-mob-spawning");
                if (!(flag instanceof StateFlag)) break block8;
                MOB_SPAWNING = (StateFlag)flag;
            }
        }
    }

    public boolean hasBlockChanges(int n, int n2, World world) {
        if (!this.getPermanentSeason(n, n2, world).equals((Object)Season.DISABLED)) {
            return false;
        }
        ApplicableRegionSet applicableRegionSet = this.getApplicableRegions(n, n2, world);
        if (applicableRegionSet == null) {
            return false;
        }
        return applicableRegionSet.testState(null, new StateFlag[]{BLOCK_CHANGES});
    }

    public boolean hasMobSpawns(int n, int n2, World world) {
        if (!this.getPermanentSeason(n, n2, world).equals((Object)Season.DISABLED)) {
            return false;
        }
        ApplicableRegionSet applicableRegionSet = this.getApplicableRegions(n, n2, world);
        if (applicableRegionSet == null) {
            return false;
        }
        return applicableRegionSet.testState(null, new StateFlag[]{MOB_SPAWNING});
    }

    public boolean hasSeasonEffects(int n, int n2, World world) {
        ApplicableRegionSet applicableRegionSet = this.getApplicableRegions(n, n2, world);
        if (applicableRegionSet == null) {
            return true;
        }
        if (!this.getPermanentSeason(n, n2, world).equals((Object)Season.DISABLED)) {
            return false;
        }
        return applicableRegionSet.testState(null, new StateFlag[]{SEASON_EFFECTS});
    }

    public Integer getPermanentTemperature(int n, int n2, World world) {
        ApplicableRegionSet applicableRegionSet = this.getApplicableRegions(n, n2, world);
        if (applicableRegionSet == null) {
            return null;
        }
        return (Integer)applicableRegionSet.queryValue(null, (Flag)TEMPERATURE);
    }

    public Integer getTemperatureModifier(int n, int n2, World world) {
        ApplicableRegionSet applicableRegionSet = this.getApplicableRegions(n, n2, world);
        if (applicableRegionSet == null) {
            return null;
        }
        return (Integer)applicableRegionSet.queryValue(null, (Flag)TEMPERATUREMODIFIER);
    }

    public Season getPermanentSeason(int n, int n2, World world) {
        ApplicableRegionSet applicableRegionSet = this.getApplicableRegions(n, n2, world);
        if (applicableRegionSet == null) {
            return Season.DISABLED;
        }
        WGSeason wGSeason = (WGSeason)((Object)applicableRegionSet.queryValue(null, SEASON_FLAG));
        if (wGSeason == null) {
            return Season.DISABLED;
        }
        return WGSeason.getRSSeason(wGSeason);
    }

    private ApplicableRegionSet getApplicableRegions(int n, int n2, World world) {
        RegionManager regionManager;
        n <<= 4;
        n2 <<= 4;
        RegionContainer regionContainer = WorldGuard.getInstance().getPlatform().getRegionContainer();
        if (regionContainer == null || (regionManager = regionContainer.get(BukkitAdapter.adapt((World)world))) == null) {
            return null;
        }
        BlockVector3 blockVector3 = BlockVector3.at((int)n, (int)this.main.getNMSUtils().getMinHeight(world), (int)n2);
        BlockVector3 blockVector32 = BlockVector3.at((int)(n + 15), (int)this.main.getNMSUtils().getMaxHeight(world), (int)(n2 + 15));
        ProtectedCuboidRegion protectedCuboidRegion = new ProtectedCuboidRegion("ThisIsAnId", blockVector3, blockVector32);
        return regionManager.getApplicableRegions((ProtectedRegion)protectedCuboidRegion);
    }
}

