/*
 * Decompiled with CFR 0.152.
 */
package me.casperge.realisticseasons.data.chunksaver;

import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import me.casperge.realisticseasons.RealisticSeasons;
import me.casperge.realisticseasons.data.chunksaver.AsyncDataSaver;
import me.casperge.realisticseasons.season.SeasonChunk;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class ChunkDataHandler {
    private RealisticSeasons main;
    private AsyncDataSaver saver;
    AtomicBoolean isActive = new AtomicBoolean(false);

    public ChunkDataHandler(final RealisticSeasons realisticSeasons) {
        this.main = realisticSeasons;
        this.saver = new AsyncDataSaver(realisticSeasons);
        if (realisticSeasons.getSettings().canCheckUnloadedChunks && realisticSeasons.getSettings().modifyBlocks) {
            int n = realisticSeasons.getSettings().delayPerAsyncChunk;
            if (this.isActive.get()) {
                return;
            }
            this.isActive.set(true);
            Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)realisticSeasons, new Runnable(){

                @Override
                public void run() {
                    ChunkDataHandler.this.saver.tick();
                    final ArrayList<SeasonChunk> arrayList = new ArrayList<SeasonChunk>();
                    Set<String> set = ChunkDataHandler.this.saver.getWorlds();
                    if (set == null) {
                        return;
                    }
                    for (String string : ChunkDataHandler.this.saver.getWorlds()) {
                        SeasonChunk seasonChunk = ChunkDataHandler.this.saver.getRandomChunk(string);
                        if (seasonChunk == null) continue;
                        arrayList.add(seasonChunk);
                    }
                    Bukkit.getScheduler().runTask((Plugin)realisticSeasons, new Runnable(){

                        @Override
                        public void run() {
                            for (SeasonChunk seasonChunk : arrayList) {
                                realisticSeasons.getSeasonManager().checkChunk(seasonChunk);
                            }
                            ChunkDataHandler.this.isActive.set(false);
                        }
                    });
                }
            }, (long)n, (long)n);
        }
    }

    public void logChunk(SeasonChunk seasonChunk) {
        this.saver.saveChunk(seasonChunk);
    }

    public void remove(SeasonChunk seasonChunk) {
        this.saver.deleteChunk(seasonChunk);
    }
}

