/*
 * Decompiled with CFR 0.152.
 */
package me.casperge.realisticseasons.event;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.casperge.realisticseasons.RealisticSeasons;
import me.casperge.realisticseasons.season.Season;
import me.casperge.realisticseasons.utils.JavaUtils;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.FluidLevelChangeEvent;
import org.bukkit.event.block.MoistureChangeEvent;
import org.bukkit.plugin.Plugin;

public class BlockEvents
implements Listener {
    private RealisticSeasons main;
    public static List<Block> placed = new ArrayList<Block>();
    boolean testBoolean = true;
    private final List<Material> logPlaceAndBreak = new ArrayList<Material>(Arrays.asList(Material.DANDELION, Material.POPPY, Material.BLUE_ORCHID, Material.ALLIUM, Material.AZURE_BLUET, Material.ORANGE_TULIP, Material.PINK_TULIP, Material.RED_TULIP, Material.WHITE_TULIP, Material.OXEYE_DAISY, Material.CORNFLOWER, Material.LILY_OF_THE_VALLEY, Material.RED_MUSHROOM, Material.BROWN_MUSHROOM, Material.SWEET_BERRY_BUSH));

    public BlockEvents(RealisticSeasons realisticSeasons) {
        realisticSeasons.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)realisticSeasons);
        this.main = realisticSeasons;
    }

    @EventHandler
    public void moistureChange(MoistureChangeEvent moistureChangeEvent) {
        if (this.main.getSeasonManager().getSeason(moistureChangeEvent.getBlock().getWorld()) == Season.WINTER) {
            if (!this.main.getSettings().modifyBlocks || !this.main.getSettings().spawnIceInWinter) {
                return;
            }
            if (moistureChangeEvent.getBlock().getWorld().getHighestBlockAt(moistureChangeEvent.getBlock().getLocation()).getLocation().equals((Object)moistureChangeEvent.getBlock().getLocation())) {
                moistureChangeEvent.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onGrow(BlockGrowEvent blockGrowEvent) {
        if (blockGrowEvent.isCancelled()) {
            return;
        }
        if (this.main.hasSeasons(blockGrowEvent.getBlock().getChunk().getX(), blockGrowEvent.getBlock().getChunk().getZ(), blockGrowEvent.getBlock().getWorld()) && blockGrowEvent.getBlock().getWorld().getEnvironment() != World.Environment.NETHER && blockGrowEvent.getBlock().getWorld().getEnvironment() != World.Environment.THE_END) {
            if (this.main.getSeasonManager().getSeason(blockGrowEvent.getBlock().getWorld()) == Season.SUMMER && this.main.getSettings().affectCropsSummer) {
                if (blockGrowEvent.getBlock().getWorld().getHighestBlockAt(blockGrowEvent.getBlock().getLocation()).getRelative(BlockFace.UP).getY() == blockGrowEvent.getBlock().getY()) {
                    BlockData blockData = blockGrowEvent.getBlock().getBlockData();
                    int n = this.main.getSeasonManager().getSubSeason(blockGrowEvent.getBlock().getWorld()).getPhase();
                    if ((n == 0 || n == 4) && JavaUtils.getRandom().nextInt(2) == 0) {
                        return;
                    }
                    if ((n == 1 || n == 3) && JavaUtils.getRandom().nextDouble() > 75.0) {
                        return;
                    }
                    if (blockData instanceof Ageable) {
                        Ageable ageable = (Ageable)blockData;
                        if (ageable.getAge() <= ageable.getMaximumAge() - 2) {
                            blockGrowEvent.setCancelled(true);
                            ageable.setAge(ageable.getAge() + 2);
                            blockGrowEvent.getBlock().setBlockData((BlockData)ageable);
                        } else if (ageable.getAge() == ageable.getMaximumAge() - 1) {
                            blockGrowEvent.setCancelled(true);
                            ageable.setAge(ageable.getAge() + 1);
                            blockGrowEvent.getBlock().setBlockData((BlockData)ageable);
                        }
                    }
                }
            } else if (this.main.getSeasonManager().getSeason(blockGrowEvent.getBlock().getWorld()) == Season.WINTER && this.main.getSettings().affectCropsWinter) {
                int n = this.main.getSeasonManager().getSubSeason(blockGrowEvent.getBlock().getWorld()).getPhase();
                if ((n == 0 || n == 4) && JavaUtils.getRandom().nextInt(2) == 0) {
                    return;
                }
                if ((n == 1 || n == 3) && JavaUtils.getRandom().nextDouble() > 75.0) {
                    return;
                }
                if (blockGrowEvent.getBlock().getWorld().getHighestBlockAt(blockGrowEvent.getBlock().getLocation()).getRelative(BlockFace.UP).getY() == blockGrowEvent.getBlock().getY()) {
                    blockGrowEvent.setCancelled(true);
                }
            }
        }
    }

    @EventHandler
    public void onFluidChange(FluidLevelChangeEvent fluidLevelChangeEvent) {
        if (placed.contains(fluidLevelChangeEvent.getBlock())) {
            placed.remove(fluidLevelChangeEvent.getBlock());
            fluidLevelChangeEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void naturalFreezeEvent(BlockFormEvent blockFormEvent) {
        if ((blockFormEvent.getNewState().getBlock().getType() == Material.ICE || blockFormEvent.getNewState().getBlock().getType() == Material.SNOW) && this.main.getBlockUtils().affectBlockInWinter(blockFormEvent.getNewState().getBlock())) {
            blockFormEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void blockPlace(BlockPlaceEvent blockPlaceEvent) {
        if (!this.main.getSettings().keepPlayerPlacedPlants) {
            return;
        }
        if (this.main.getSeasonManager().worldData.containsKey(blockPlaceEvent.getBlock().getWorld()) && this.main.getSeasonManager().worldData.get(blockPlaceEvent.getBlock().getWorld()) != Season.DISABLED && this.logPlaceAndBreak.contains(blockPlaceEvent.getBlockPlaced().getType())) {
            this.main.getBlockStorage().logPlacement(blockPlaceEvent.getBlock().getLocation());
        }
    }

    @EventHandler
    public void grassDestroy(BlockFadeEvent blockFadeEvent) {
        if (blockFadeEvent.getBlock().getType().equals((Object)Material.GRASS_BLOCK) && (blockFadeEvent.getBlock().getRelative(BlockFace.UP).getType().equals((Object)Material.SNOW) || blockFadeEvent.getBlock().getRelative(BlockFace.UP).getType().equals((Object)Material.SNOW_BLOCK))) {
            blockFadeEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void blockPlace(BlockBreakEvent blockBreakEvent) {
        if (this.logPlaceAndBreak.contains(blockBreakEvent.getBlock().getType())) {
            this.main.getBlockStorage().logBreak(blockBreakEvent.getBlock().getLocation());
        }
    }
}

