/*
 * Decompiled with CFR 0.152.
 */
package me.casperge.realisticseasons.event;

import me.casperge.realisticseasons.RealisticSeasons;
import me.casperge.realisticseasons.event.UnexpectedChunkLoadException;
import me.casperge.realisticseasons.season.Season;
import me.casperge.realisticseasons.season.SeasonChunk;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.plugin.Plugin;

public class ChunkLoadManager
implements Listener {
    private RealisticSeasons main;

    public ChunkLoadManager(RealisticSeasons realisticSeasons) {
        this.main = realisticSeasons;
        if (!realisticSeasons.getSettings().modifyBlocks && !realisticSeasons.getSettings().spawnEntities) {
            return;
        }
        realisticSeasons.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)realisticSeasons);
    }

    @EventHandler
    public void onLoad(ChunkLoadEvent chunkLoadEvent) {
        int n;
        if (this.main.debugMode) {
            UnexpectedChunkLoadException unexpectedChunkLoadException = new UnexpectedChunkLoadException();
            n = 0;
            boolean bl = false;
            for (StackTraceElement stackTraceElement : unexpectedChunkLoadException.getStackTrace()) {
                if (stackTraceElement.toString().contains("casperge") && !stackTraceElement.toString().contains("ChunkLoadManager")) {
                    n = 1;
                }
                if (!stackTraceElement.toString().contains("casperge") || !stackTraceElement.toString().contains("checkChunk")) continue;
                bl = true;
            }
            if (n != 0 && !bl) {
                Bukkit.getLogger().warning("RealisticSeasons tried to load chunk: " + String.valueOf(chunkLoadEvent.getChunk().getX()) + ", " + String.valueOf(chunkLoadEvent.getChunk().getZ()) + " in world " + chunkLoadEvent.getChunk().getWorld().getName());
                unexpectedChunkLoadException.printStackTrace();
            }
        }
        int n2 = chunkLoadEvent.getChunk().getX();
        n = chunkLoadEvent.getChunk().getZ();
        if (n2 > 1875000 || n > 1875000 || n2 < -1875000 || n < -1875000) {
            return;
        }
        if (chunkLoadEvent.getWorld().getEnvironment() != World.Environment.NETHER && chunkLoadEvent.getWorld().getEnvironment() != World.Environment.THE_END) {
            SeasonChunk seasonChunk = new SeasonChunk(chunkLoadEvent.getChunk().getWorld().getName(), chunkLoadEvent.getChunk().getX(), chunkLoadEvent.getChunk().getZ(), System.currentTimeMillis());
            if (this.main.getSeasonManager().getSeason(chunkLoadEvent.getWorld()) == Season.SPRING) {
                if (!this.main.getSeasonManager().getCheckedList(chunkLoadEvent.getChunk().getWorld(), Season.SPRING).contains(seasonChunk) && !this.main.getSeasonManager().getQueue(chunkLoadEvent.getChunk().getWorld(), Season.SPRING).contains(seasonChunk)) {
                    this.main.getSeasonManager().getQueue(chunkLoadEvent.getChunk().getWorld(), Season.SPRING).add(seasonChunk);
                }
            } else if (this.main.getSeasonManager().getSeason(chunkLoadEvent.getWorld()) == Season.SUMMER) {
                if (!this.main.getSeasonManager().getCheckedList(chunkLoadEvent.getChunk().getWorld(), Season.SUMMER).contains(seasonChunk) && !this.main.getSeasonManager().getQueue(chunkLoadEvent.getChunk().getWorld(), Season.SUMMER).contains(seasonChunk)) {
                    this.main.getSeasonManager().getQueue(chunkLoadEvent.getChunk().getWorld(), Season.SUMMER).add(seasonChunk);
                }
            } else if (this.main.getSeasonManager().getSeason(chunkLoadEvent.getWorld()) == Season.FALL) {
                if (!this.main.getSeasonManager().getCheckedList(chunkLoadEvent.getChunk().getWorld(), Season.FALL).contains(seasonChunk) && !this.main.getSeasonManager().getQueue(chunkLoadEvent.getChunk().getWorld(), Season.FALL).contains(seasonChunk)) {
                    this.main.getSeasonManager().getQueue(chunkLoadEvent.getChunk().getWorld(), Season.FALL).add(seasonChunk);
                }
            } else if (this.main.getSeasonManager().getSeason(chunkLoadEvent.getWorld()) == Season.RESTORE && !this.main.getSeasonManager().getCheckedList(chunkLoadEvent.getChunk().getWorld(), Season.RESTORE).contains(seasonChunk) && !this.main.getSeasonManager().getQueue(chunkLoadEvent.getChunk().getWorld(), Season.RESTORE).contains(seasonChunk)) {
                this.main.getSeasonManager().getQueue(chunkLoadEvent.getChunk().getWorld(), Season.RESTORE).add(seasonChunk);
            }
        }
    }

    @EventHandler
    public void onUnload(ChunkUnloadEvent chunkUnloadEvent) {
        if (!this.main.isEnabled()) {
            return;
        }
        int n = chunkUnloadEvent.getChunk().getX();
        int n2 = chunkUnloadEvent.getChunk().getZ();
        if (n > 1875000 || n2 > 1875000 || n < -1875000 || n2 < -1875000) {
            return;
        }
        if (chunkUnloadEvent.getWorld().getEnvironment() != World.Environment.NETHER && chunkUnloadEvent.getWorld().getEnvironment() != World.Environment.THE_END) {
            if (this.main.getSeasonManager().getSeason(chunkUnloadEvent.getWorld()) == Season.SPRING) {
                SeasonChunk seasonChunk = new SeasonChunk(chunkUnloadEvent.getChunk().getWorld().getName(), chunkUnloadEvent.getChunk().getX(), chunkUnloadEvent.getChunk().getZ(), 0L);
                if (!this.main.getSeasonManager().getCheckedList(chunkUnloadEvent.getChunk().getWorld(), Season.SPRING).contains(seasonChunk) && this.main.getSeasonManager().getQueue(chunkUnloadEvent.getChunk().getWorld(), Season.SPRING).contains(seasonChunk)) {
                    this.main.getSeasonManager().getQueue(chunkUnloadEvent.getChunk().getWorld(), Season.SPRING).remove(seasonChunk);
                }
            } else if (this.main.getSeasonManager().getSeason(chunkUnloadEvent.getWorld()) == Season.SUMMER) {
                SeasonChunk seasonChunk = new SeasonChunk(chunkUnloadEvent.getChunk().getWorld().getName(), chunkUnloadEvent.getChunk().getX(), chunkUnloadEvent.getChunk().getZ(), 0L);
                if (!this.main.getSeasonManager().getCheckedList(chunkUnloadEvent.getChunk().getWorld(), Season.SUMMER).contains(seasonChunk) && this.main.getSeasonManager().getQueue(chunkUnloadEvent.getChunk().getWorld(), Season.SUMMER).contains(seasonChunk)) {
                    this.main.getSeasonManager().getQueue(chunkUnloadEvent.getChunk().getWorld(), Season.SUMMER).remove(seasonChunk);
                }
            } else if (this.main.getSeasonManager().getSeason(chunkUnloadEvent.getWorld()) == Season.FALL) {
                SeasonChunk seasonChunk = new SeasonChunk(chunkUnloadEvent.getChunk().getWorld().getName(), chunkUnloadEvent.getChunk().getX(), chunkUnloadEvent.getChunk().getZ(), 0L);
                if (!this.main.getSeasonManager().getCheckedList(chunkUnloadEvent.getChunk().getWorld(), Season.FALL).contains(seasonChunk) && this.main.getSeasonManager().getQueue(chunkUnloadEvent.getChunk().getWorld(), Season.FALL).contains(seasonChunk)) {
                    this.main.getSeasonManager().getQueue(chunkUnloadEvent.getChunk().getWorld(), Season.FALL).remove(seasonChunk);
                }
            } else if (this.main.getSeasonManager().getSeason(chunkUnloadEvent.getWorld()) == Season.RESTORE) {
                SeasonChunk seasonChunk = new SeasonChunk(chunkUnloadEvent.getChunk().getWorld().getName(), chunkUnloadEvent.getChunk().getX(), chunkUnloadEvent.getChunk().getZ(), 0L);
                if (!this.main.getSeasonManager().getCheckedList(chunkUnloadEvent.getChunk().getWorld(), Season.RESTORE).contains(seasonChunk) && this.main.getSeasonManager().getQueue(chunkUnloadEvent.getChunk().getWorld(), Season.RESTORE).contains(seasonChunk)) {
                    this.main.getSeasonManager().getQueue(chunkUnloadEvent.getChunk().getWorld(), Season.RESTORE).remove(seasonChunk);
                }
            }
        }
    }
}

