/*
 * Decompiled with CFR 0.152.
 */
package me.casperge.realisticseasons.event;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import me.casperge.realisticseasons.RealisticSeasons;
import me.casperge.realisticseasons.commands.ToggleSeasonsCommand;
import me.casperge.realisticseasons.season.Season;
import me.casperge.realisticseasons.season.SubSeason;
import me.casperge.realisticseasons1_19_R1.ProtocolLibUtils1_19_R1;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import world.ofunny.bpm.Floodgate.FloodgateAPI;

public class ChunkPacketEventProtocolLib1_19_R1 {
    private ProtocolLibUtils1_19_R1 protutils = new ProtocolLibUtils1_19_R1();

    public ChunkPacketEventProtocolLib1_19_R1(final RealisticSeasons realisticSeasons) {
        ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)new PacketAdapter((Plugin)realisticSeasons, new PacketType[]{PacketType.Play.Server.MAP_CHUNK}){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void onPacketSending(PacketEvent packetEvent) {
                PacketContainer packetContainer = packetEvent.getPacket();
                Player player = packetEvent.getPlayer();
                if (!realisticSeasons.getSettings().affectBiomes) return;
                int n = (Integer)packetContainer.getIntegers().read(0);
                int n2 = (Integer)packetContainer.getIntegers().read(1);
                Season season = realisticSeasons.getSeasonManager().getSeason(player.getWorld());
                SubSeason subSeason = SubSeason.MIDDLE;
                if (season == Season.FALL || season == Season.WINTER || season == Season.SPRING || season == Season.SUMMER) {
                    subSeason = realisticSeasons.getSeasonManager().getSubSeason(player.getWorld());
                }
                if (!realisticSeasons.hasSeasons(n, n2, player.getWorld())) {
                    if (!realisticSeasons.hasWorldGuard()) return;
                    if (realisticSeasons.getWorldGuardAPI().getPermanentSeason(n, n2, player.getWorld()) == Season.DISABLED) return;
                    season = realisticSeasons.getWorldGuardAPI().getPermanentSeason(n, n2, player.getWorld());
                }
                if (ToggleSeasonsCommand.disabled.contains(player.getUniqueId())) {
                    return;
                }
                if (season == Season.WINTER) {
                    if (FloodgateAPI.get().isBedrockPlayer(player) || !realisticSeasons.supportsCustomBiomes(player)) {
                        ChunkPacketEventProtocolLib1_19_R1.this.protutils.readPacket(packetContainer, player.getWorld(), Season.WINTER.intValue(), true, subSeason.getPhase());
                        return;
                    }
                    ChunkPacketEventProtocolLib1_19_R1.this.protutils.readPacket(packetContainer, player.getWorld(), Season.WINTER.intValue(), false, subSeason.getPhase());
                    return;
                }
                if (season == Season.FALL) {
                    if (FloodgateAPI.get().isBedrockPlayer(player) || !realisticSeasons.supportsCustomBiomes(player)) {
                        ChunkPacketEventProtocolLib1_19_R1.this.protutils.readPacket(packetContainer, player.getWorld(), Season.FALL.intValue(), true, subSeason.getPhase());
                        return;
                    }
                    ChunkPacketEventProtocolLib1_19_R1.this.protutils.readPacket(packetContainer, player.getWorld(), Season.FALL.intValue(), false, subSeason.getPhase());
                    return;
                }
                if (season == Season.SPRING) {
                    if (FloodgateAPI.get().isBedrockPlayer(player) || !realisticSeasons.supportsCustomBiomes(player)) {
                        return;
                    }
                    ChunkPacketEventProtocolLib1_19_R1.this.protutils.readPacket(packetContainer, player.getWorld(), Season.SPRING.intValue(), false, subSeason.getPhase());
                    return;
                }
                if (season != Season.SUMMER) return;
                if (FloodgateAPI.get().isBedrockPlayer(player) || !realisticSeasons.supportsCustomBiomes(player)) {
                    return;
                }
                ChunkPacketEventProtocolLib1_19_R1.this.protutils.readPacket(packetContainer, player.getWorld(), Season.SUMMER.intValue(), false, subSeason.getPhase());
            }
        });
    }
}

