/*
 * Decompiled with CFR 0.152.
 */
package me.casperge.realisticseasons.event;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import java.util.HashMap;
import me.casperge.realisticseasons.RealisticSeasons;
import me.casperge.realisticseasons.biome.HeightAccessor;
import me.casperge.realisticseasons.commands.ToggleSeasonsCommand;
import me.casperge.realisticseasons.event.ChunkPacketProcessor;
import me.casperge.realisticseasons.season.Season;
import me.casperge.realisticseasons.season.SubSeason;
import me.casperge.realisticseasons1_19_R3.NmsCode_19_R3;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import world.ofunny.bpm.Floodgate.FloodgateAPI;

public class ChunkPacketEventProtocolLibAsync {
    private RealisticSeasons main;
    private ChunkPacketProcessor processor;
    boolean accessorRequired = true;
    HashMap<String, HeightAccessor> heightAccessors = new HashMap();

    public ChunkPacketEventProtocolLibAsync(final RealisticSeasons realisticSeasons, ChunkPacketProcessor chunkPacketProcessor) {
        this.processor = chunkPacketProcessor;
        this.main = realisticSeasons;
        ProtocolLibrary.getProtocolManager().getAsynchronousManager().registerAsyncHandler((PacketListener)new PacketAdapter((Plugin)realisticSeasons, new PacketType[]{PacketType.Play.Server.MAP_CHUNK}){

            public void onPacketSending(final PacketEvent packetEvent) {
                final PacketContainer packetContainer = packetEvent.getPacket();
                final Player player = packetEvent.getPlayer();
                final int n = (Integer)packetContainer.getIntegers().read(0);
                final int n2 = (Integer)packetContainer.getIntegers().read(1);
                final World world = packetEvent.getPlayer().getWorld();
                packetEvent.getAsyncMarker().incrementProcessingDelay();
                Bukkit.getScheduler().runTask((Plugin)realisticSeasons, new Runnable(){

                    @Override
                    public void run() {
                        ChunkPacketEventProtocolLibAsync.this.processSyncPreConditions(player, world, n, n2, packetContainer, packetEvent);
                    }
                });
            }
        }).start();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void processSyncPreConditions(Player player, World world, int n, int n2, PacketContainer packetContainer, PacketEvent packetEvent) {
        if (this.main.getSettings().affectBiomes) {
            Season season = this.main.getSeasonManager().getSeason(world);
            SubSeason subSeason = SubSeason.MIDDLE;
            if (season == Season.FALL || season == Season.WINTER || season == Season.SPRING || season == Season.SUMMER) {
                subSeason = this.main.getSeasonManager().getSubSeason(world);
            }
            if (!this.main.hasSeasons(n, n2, world)) {
                if (!this.main.hasWorldGuard()) {
                    this.cancelPacketProcessing(packetEvent);
                    return;
                }
                if (this.main.getWorldGuardAPI().getPermanentSeason(n, n2, world) == Season.DISABLED) {
                    this.cancelPacketProcessing(packetEvent);
                    return;
                }
                season = this.main.getWorldGuardAPI().getPermanentSeason(n, n2, world);
            }
            if (ToggleSeasonsCommand.disabled.contains(player.getUniqueId())) {
                this.cancelPacketProcessing(packetEvent);
                return;
            }
            if (season == Season.WINTER) {
                if (!FloodgateAPI.get().isBedrockPlayer(player) && this.main.supportsCustomBiomes(player)) {
                    this.processBiomeData(packetEvent, packetContainer, world, Season.WINTER.intValue(), false, subSeason.getPhase());
                    return;
                }
                this.processBiomeData(packetEvent, packetContainer, world, Season.WINTER.intValue(), true, subSeason.getPhase());
                return;
            }
            if (season == Season.FALL) {
                if (!FloodgateAPI.get().isBedrockPlayer(player) && this.main.supportsCustomBiomes(player)) {
                    this.processBiomeData(packetEvent, packetContainer, world, Season.FALL.intValue(), false, subSeason.getPhase());
                    return;
                }
                this.processBiomeData(packetEvent, packetContainer, world, Season.FALL.intValue(), true, subSeason.getPhase());
                return;
            }
            if (season == Season.SPRING) {
                if (!FloodgateAPI.get().isBedrockPlayer(player) && this.main.supportsCustomBiomes(player)) {
                    this.processBiomeData(packetEvent, packetContainer, world, Season.SPRING.intValue(), false, subSeason.getPhase());
                    return;
                }
                this.cancelPacketProcessing(packetEvent);
                return;
            }
            if (season == Season.SUMMER) {
                if (!FloodgateAPI.get().isBedrockPlayer(player) && this.main.supportsCustomBiomes(player)) {
                    this.processBiomeData(packetEvent, packetContainer, world, Season.SUMMER.intValue(), false, subSeason.getPhase());
                    return;
                }
                this.cancelPacketProcessing(packetEvent);
                return;
            }
        }
        this.cancelPacketProcessing(packetEvent);
    }

    public void processBiomeData(PacketEvent packetEvent, PacketContainer packetContainer, World world, int n, boolean bl, int n2) {
        int n3 = this.main.getNMSUtils().getSectionCount(world);
        HeightAccessor heightAccessor = null;
        if (this.accessorRequired) {
            if (!this.heightAccessors.isEmpty()) {
                if (this.heightAccessors.containsKey(world.getName())) {
                    heightAccessor = this.heightAccessors.get(world.getName());
                } else {
                    heightAccessor = this.generateAccessor(world);
                    this.heightAccessors.put(world.getName(), heightAccessor);
                }
            } else if (this.main.getNMSUtils() instanceof NmsCode_19_R3) {
                heightAccessor = this.generateAccessor(world);
                this.heightAccessors.put(world.getName(), heightAccessor);
            } else {
                this.accessorRequired = false;
            }
        }
        this.processor.addEntry(packetEvent, n, bl, n2, n3, heightAccessor);
    }

    public void cancelPacketProcessing(PacketEvent packetEvent) {
        ProtocolLibrary.getProtocolManager().getAsynchronousManager().signalPacketTransmission(packetEvent);
    }

    private HeightAccessor generateAccessor(World world) {
        if (this.main.getNMSUtils() instanceof NmsCode_19_R3) {
            HashMap<Integer, Integer> hashMap = ((NmsCode_19_R3)this.main.getNMSUtils()).generateHeightAccessor(world);
            HeightAccessor heightAccessor = new HeightAccessor();
            for (Integer n : hashMap.keySet()) {
                heightAccessor.add(n, hashMap.get(n));
            }
            return heightAccessor;
        }
        return null;
    }
}

