/*
 * Decompiled with CFR 0.152.
 */
package me.casperge.realisticseasons.event;

import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketEvent;
import java.util.ArrayList;
import java.util.List;
import me.casperge.interfaces.ProtocolLibUtils;
import me.casperge.realisticseasons.RealisticSeasons;
import me.casperge.realisticseasons.biome.HeightAccessor;
import me.casperge.realisticseasons.event.ChunkPacketEntry;

public class ChunkPacketProcessor
implements Runnable {
    static final int MAXQUEUE = 200000;
    private List<ChunkPacketEntry> entries = new ArrayList<ChunkPacketEntry>();
    private ProtocolLibUtils protutils;

    public ChunkPacketProcessor(ProtocolLibUtils protocolLibUtils) {
        this.protutils = protocolLibUtils;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (RealisticSeasons.isEnabled.get()) {
            ChunkPacketProcessor chunkPacketProcessor = this;
            synchronized (chunkPacketProcessor) {
                if (!this.entries.isEmpty()) {
                    this.handleEntry();
                } else {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void handleEntry() {
        ChunkPacketEntry chunkPacketEntry = this.entries.remove(0);
        Object object = chunkPacketEntry.getEvent().getAsyncMarker().getProcessingLock();
        synchronized (object) {
            this.protutils.readPacket(chunkPacketEntry.getEvent().getPacket(), chunkPacketEntry.getSeason(), chunkPacketEntry.isBedrock(), chunkPacketEntry.getPhase(), chunkPacketEntry.getySectionCount(), chunkPacketEntry.getAccessor());
            ProtocolLibrary.getProtocolManager().getAsynchronousManager().signalPacketTransmission(chunkPacketEntry.getEvent());
        }
    }

    public synchronized void addEntry(PacketEvent packetEvent, int n, boolean bl, int n2, int n3, HeightAccessor heightAccessor) {
        this.entries.add(new ChunkPacketEntry(packetEvent, n, bl, n2, n3, heightAccessor));
        this.notify();
    }
}

