/*
 * Decompiled with CFR 0.152.
 */
package me.casperge.realisticseasons.particle.entity;

import java.util.List;
import me.casperge.realisticseasons.particle.entity.SeasonEntity;
import me.casperge.realisticseasons.utils.JavaUtils;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class Meteorite
implements SeasonEntity {
    private Vector direction;
    private Location currentLocation;
    private int size;
    private int count = 0;
    private boolean isDestroyed = false;

    public Meteorite(Location location, List<Player> list) {
        double[] dArray = JavaUtils.toCartesianAsVector(JavaUtils.getRandom().nextInt(360));
        this.direction = new Vector(dArray[0], 0.0, dArray[1]).normalize().multiply(5);
        this.size = 10 + JavaUtils.getRandom().nextInt(60);
        this.currentLocation = location.clone().subtract(this.direction.clone().multiply(this.size / 2));
    }

    @Override
    public void tick(List<Player> list) {
        ++this.count;
        if (!this.isDestroyed) {
            this.playParticle();
            this.currentLocation.add(this.direction);
            if (this.count > this.size) {
                this.isDestroyed = true;
            }
        }
    }

    private void playParticle() {
        double d2 = 1.25 - (double)JavaUtils.getRandom().nextInt(50) / 100.0;
        this.currentLocation.getWorld().spawnParticle(Particle.FLAME, this.currentLocation.getX(), this.currentLocation.getY(), this.currentLocation.getZ(), 35, 0.25 * d2, 0.25 * d2, 0.25 * d2, 0.0, null, true);
        this.currentLocation.getWorld().spawnParticle(Particle.FLAME, this.currentLocation.clone().subtract(this.direction.clone().multiply(0.3)), 35, 0.25 * d2, 0.25 * d2, 0.25 * d2, 0.0, null, true);
        this.currentLocation.getWorld().spawnParticle(Particle.FLAME, this.currentLocation.clone().subtract(this.direction.clone().multiply(0.6)), 35, 0.25 * d2, 0.25 * d2, 0.25 * d2, 0.0, null, true);
        this.currentLocation.getWorld().spawnParticle(Particle.SMOKE_NORMAL, this.currentLocation.clone().subtract(this.direction), 25, 0.5 * d2, 0.5 * d2, 0.5 * d2, 0.0, null, true);
    }

    @Override
    public boolean isDestroyed() {
        return this.isDestroyed;
    }

    @Override
    public Location getLocation() {
        return this.currentLocation;
    }
}

