/*
 * Decompiled with CFR 0.152.
 */
package me.casperge.realisticseasons.season;

import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import me.casperge.realisticseasons.RealisticSeasons;
import me.casperge.realisticseasons.calendar.Date;
import me.casperge.realisticseasons.season.Season;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.scheduler.BukkitRunnable;

public class SeasonCycle
extends BukkitRunnable {
    private RealisticSeasons main;
    private HashMap<World, Long> lastRecordedTime = new HashMap();
    public ZonedDateTime lastRecordedRealLifeTime;

    public SeasonCycle(RealisticSeasons realisticSeasons) {
        this.main = realisticSeasons;
    }

    /*
     * WARNING - void declaration
     */
    public void run() {
        if (!this.main.getSettings().calendarEnabled) {
            this.cancel();
        }
        ArrayList<World> arrayList = new ArrayList<World>();
        for (String object : this.main.getSettings().syncedWorlds) {
            World world;
            if (Bukkit.getWorld((String)object) == null || !this.lastRecordedTime.containsKey(world = Bukkit.getWorld((String)object))) continue;
            arrayList.add(world);
        }
        if (arrayList.size() > 1) {
            Object object = -10L;
            for (World world : arrayList) {
                if ((Long)object == -10L) {
                    object = world.getFullTime();
                    continue;
                }
                if ((Long)object >= world.getFullTime()) continue;
                object = world.getFullTime();
            }
            for (World world : arrayList) {
                if (world.getFullTime() == ((Long)object).longValue()) continue;
                world.setFullTime(((Long)object).longValue());
            }
        }
        this.handleTimeChanges();
        if (arrayList.size() > 1) {
            int n = -1;
            Object var3_8 = null;
            for (World world : arrayList) {
                if (n == -1) {
                    n = this.main.getTimeManager().getCalendar().getTotalDays(this.main.getTimeManager().getDate(world));
                    World world2 = world;
                    continue;
                }
                if (this.main.getTimeManager().getCalendar().getTotalDays(this.main.getTimeManager().getDate(world)) <= n) continue;
                n = this.main.getTimeManager().getCalendar().getTotalDays(this.main.getTimeManager().getDate(world));
                World world3 = world;
            }
            for (World world : arrayList) {
                void var3_9;
                if (this.main.getTimeManager().getCalendar().getTotalDays(this.main.getTimeManager().getDate(world)) == n) continue;
                this.main.getTimeManager().setDate(world, this.main.getTimeManager().getDate((World)var3_9));
            }
        }
    }

    public void handleTimeChanges() {
        for (World world : Bukkit.getWorlds()) {
            if (world.getEnvironment() == World.Environment.NETHER || world.getEnvironment() == World.Environment.THE_END || this.main.getSeasonManager().getSeason(world) == Season.DISABLED || this.main.getSeasonManager().getSeason(world) == Season.RESTORE) continue;
            if (!this.lastRecordedTime.containsKey(world)) {
                this.lastRecordedTime.put(world, world.getFullTime());
                continue;
            }
            if (!this.main.getSettings().syncWorldTimeWithRealWorld) {
                if (!this.main.getSettings().isCalendarInRealLifeDays) {
                    if (this.lastRecordedTime.get(world) % 24000L < 18000L && (world.getFullTime() % 24000L > 18000L || this.lastRecordedTime.get(world) % 24000L > world.getFullTime() % 24000L)) {
                        this.main.getTimeManager().nextDay(world);
                    }
                } else {
                    int n;
                    ZonedDateTime zonedDateTime = this.main.getTimeManager().getCurrentZonedDateTime().with(LocalTime.MIDNIGHT);
                    if (this.lastRecordedRealLifeTime == null) {
                        this.lastRecordedRealLifeTime = this.main.getLoadedTime();
                        if (this.lastRecordedRealLifeTime == null) {
                            this.lastRecordedRealLifeTime = this.main.getTimeManager().getCurrentZonedDateTime().with(LocalTime.MIDNIGHT);
                        }
                    }
                    if ((n = (int)ChronoUnit.DAYS.between(this.lastRecordedRealLifeTime.with(LocalTime.MIDNIGHT), zonedDateTime)) == 0) continue;
                    if (n == 1) {
                        this.main.getTimeManager().nextDay(world);
                    }
                    if (n > 1) {
                        Date date = this.main.getTimeManager().getDate(world);
                        Date date2 = this.main.getTimeManager().getCalendar().getNextDate(date);
                        for (int i = 1; i < n; ++i) {
                            date2 = this.main.getTimeManager().getCalendar().getNextDate(date2);
                        }
                        this.main.getTimeManager().setDate(world, date2);
                    }
                    this.lastRecordedRealLifeTime = this.main.getTimeManager().getCurrentZonedDateTime().with(LocalTime.MIDNIGHT);
                }
            }
            this.lastRecordedTime.replace(world, world.getFullTime());
        }
    }
}

