/*
 * Decompiled with CFR 0.152.
 */
package me.casperge.realisticseasons.seasonevent;

import java.util.ArrayList;
import java.util.List;
import me.casperge.realisticseasons.RealisticSeasons;
import me.casperge.realisticseasons.calendar.Date;
import me.casperge.realisticseasons.calendar.TimeManager;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class EventUtils {
    private RealisticSeasons main;

    public EventUtils(RealisticSeasons realisticSeasons) {
        this.main = realisticSeasons;
    }

    public void execute(World world, List<String> list, Date date) {
        for (String string : this.main.getSettings().worldsWithoutEvents) {
            if (!string.equalsIgnoreCase(world.getName())) continue;
            return;
        }
        for (String string : this.replacePlaceholders(world, list, date)) {
            if (string.startsWith("/")) {
                Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getServer().getConsoleSender(), string.replaceFirst("/", ""));
                continue;
            }
            for (Player player : world.getPlayers()) {
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)string));
            }
        }
    }

    public List<String> replacePlaceholders(World world, List<String> list, Date date) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            String string2 = this.main.setPlaceHolders(string, null);
            string2 = string2.replaceAll("%season%", this.main.getSeasonManager().getSeason(world).toString()).replaceAll("%world%", world.getName());
            if (this.main.getSettings().calendarEnabled) {
                TimeManager timeManager = this.main.getTimeManager();
                string2 = string2.replaceAll("%month_asname%", timeManager.getCalendar().getMonth(date.getMonth()).getName()).replaceAll("%weekday%", timeManager.getWeekDay(date)).replaceAll("%day%", String.valueOf(date.getDay())).replaceAll("%year%", String.valueOf(date.getYear())).replaceAll("%year%", String.valueOf(date.getMonth())).replaceAll("%month%", String.valueOf(date.getMonth()));
            }
            arrayList.add(string2);
        }
        return arrayList;
    }
}

