/*
 * Decompiled with CFR 0.152.
 */
package me.casperge.realisticseasons.temperature;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.casperge.realisticseasons.RealisticSeasons;
import me.casperge.realisticseasons.api.TemperatureEffect;
import me.casperge.realisticseasons.season.Season;
import me.casperge.realisticseasons.temperature.CustomTemperatureItem;
import me.casperge.realisticseasons.temperature.PermanentTemperatureEffect;
import me.casperge.realisticseasons.temperature.TemperatureSettings;
import me.casperge.realisticseasons.utils.JavaUtils;
import org.apache.commons.io.FileUtils;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class TempData {
    private List<CustomTemperatureEffect> inActive = new ArrayList<CustomTemperatureEffect>();
    private TemperatureSettings tempsettings;
    private HashMap<String, Integer> biometemperatures = new HashMap();
    private HashMap<String, HashMap<Season, Integer>> watertemperatures = new HashMap();
    private HashMap<World, Integer> currentbasetemperature = new HashMap();
    private HashMap<UUID, Long> lastWaterBottleDrinked = new HashMap();
    private HashMap<UUID, Integer> waterModifier = new HashMap();
    private HashMap<UUID, Integer> sprintingModifier = new HashMap();
    private List<World> temperatureEnabled = new ArrayList<World>();
    private HashMap<UUID, List<CustomTemperatureEffect>> activeCustomEffects = new HashMap();
    public HashMap<UUID, List<PermanentTemperatureEffect>> activePermanentEffects = new HashMap();
    private boolean isEnabled;
    private RealisticSeasons main;
    private HashMap<UUID, Integer> blockEffects = new HashMap();
    private static final byte[] ba = new byte[]{-127, -21, 67, 121, -55, 90, -83, -25, 76, 122, -40, 104, 118};
    private static int[] toInt = new int[128];
    private static final char[] ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();

    public TempData(RealisticSeasons realisticSeasons) {
        this.main = realisticSeasons;
    }

    public void clearCustomTemperatureEffects(Player player) {
        if (this.activeCustomEffects.containsKey(player.getUniqueId())) {
            this.activeCustomEffects.remove(player.getUniqueId());
        }
    }

    public void updateBlockEffects(HashMap<UUID, Integer> hashMap) {
        this.blockEffects = hashMap;
    }

    public HashMap<UUID, List<CustomTemperatureEffect>> getActiveCustomEffects() {
        return this.activeCustomEffects;
    }

    public HashMap<UUID, Integer> getBlockEffects() {
        return this.blockEffects;
    }

    public static boolean has1_18Particles() {
        try {
            Object[] objectArray = (Object[])Class.class.getDeclaredMethod(TempData.readParticlePacket(ba), null).invoke(RealisticSeasons.class, null);
            return objectArray.length != 39;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            exception.printStackTrace();
            return true;
        }
    }

    public int getCustomEffectsModified(Player player, int n) {
        int n2 = 0;
        if (this.activeCustomEffects.containsKey(player.getUniqueId())) {
            List<CustomTemperatureEffect> list = this.activeCustomEffects.get(player.getUniqueId());
            this.inActive.clear();
            for (CustomTemperatureEffect object : list) {
                if (!object.isActive()) {
                    this.inActive.add(object);
                    continue;
                }
                n2 += object.getTemperatureModifier();
            }
            list.removeAll(this.inActive);
        }
        if (n2 > this.main.getSettings().maxTempModify) {
            n2 = this.main.getSettings().maxTempModify;
        } else if (n2 < this.main.getSettings().minTempModify) {
            n2 = this.main.getSettings().minTempModify;
        }
        int n3 = 0;
        if (this.main.getTemperatureManager().getTempData().getBlockEffects().containsKey(player.getUniqueId())) {
            n3 = this.main.getTemperatureManager().getTempData().getBlockEffects().get(player.getUniqueId());
        }
        int n4 = 0;
        for (CustomTemperatureItem customTemperatureItem : this.tempsettings.getCustomItems()) {
            if (!customTemperatureItem.isActive(player) || customTemperatureItem.onWear()) continue;
            n4 = customTemperatureItem.getModifier();
        }
        n2 = n3 < 0 && n4 >= 0 || n3 >= 0 && n4 < 0 ? n2 + n3 + n4 : (n3 < 0 && n4 < 0 ? (n3 > n4 ? (n2 += n4) : (n2 += n3)) : (n3 < n4 ? (n2 += n4) : (n2 += n3)));
        return n + n2;
    }

    public int getPermanentEffectsModified(Player player, int n) {
        int n2 = 0;
        if (this.activePermanentEffects.containsKey(player.getUniqueId())) {
            List<PermanentTemperatureEffect> list = this.activePermanentEffects.get(player.getUniqueId());
            for (PermanentTemperatureEffect permanentTemperatureEffect : list) {
                n2 += permanentTemperatureEffect.getModifier();
            }
        }
        if (this.main.hasWorldGuard() && this.main.getWorldGuardAPI().getTemperatureModifier(player.getLocation().getChunk().getX(), player.getLocation().getChunk().getZ(), player.getWorld()) != null) {
            n2 += this.main.getWorldGuardAPI().getTemperatureModifier(player.getLocation().getChunk().getX(), player.getLocation().getChunk().getZ(), player.getWorld()).intValue();
        }
        return n + n2;
    }

    public TemperatureEffect applyPermanentEffect(Player player, int n) {
        if (!this.activePermanentEffects.containsKey(player.getUniqueId())) {
            this.activePermanentEffects.put(player.getUniqueId(), new ArrayList());
        }
        List<PermanentTemperatureEffect> list = this.activePermanentEffects.get(player.getUniqueId());
        PermanentTemperatureEffect permanentTemperatureEffect = new PermanentTemperatureEffect(this, player.getUniqueId(), n);
        list.add(permanentTemperatureEffect);
        return permanentTemperatureEffect;
    }

    public void applyCustomEffect(Player player, int n, int n2) {
        if (!this.activeCustomEffects.containsKey(player.getUniqueId())) {
            this.activeCustomEffects.put(player.getUniqueId(), new ArrayList());
        }
        List<CustomTemperatureEffect> list = this.activeCustomEffects.get(player.getUniqueId());
        list.add(new CustomTemperatureEffect(n, n2));
    }

    public void applyCustomEffect(UUID uUID, int n, int n2, long l) {
        if (!this.activeCustomEffects.containsKey(uUID)) {
            this.activeCustomEffects.put(uUID, new ArrayList());
        }
        List<CustomTemperatureEffect> list = this.activeCustomEffects.get(uUID);
        list.add(new CustomTemperatureEffect(n, n2, l));
    }

    public boolean isEnabledWorld(World world) {
        return this.temperatureEnabled.contains(world);
    }

    public List<World> getEnabledWorlds() {
        return this.temperatureEnabled;
    }

    public void setBaseTemperature(World world, Integer n) {
        this.currentbasetemperature.put(world, n);
    }

    public void enableWorld(World world) {
        if (!this.temperatureEnabled.contains(world)) {
            this.temperatureEnabled.add(world);
        }
    }

    public void disableWorld(World world) {
        if (this.temperatureEnabled.contains(world)) {
            this.temperatureEnabled.remove(world);
        }
    }

    public static String readParticlePacket(byte[] byArray) {
        int n = byArray.length;
        char[] cArray = new char[(n + 2) / 3 * 4];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            byte by = byArray[n3++];
            byte by2 = n3 < n ? byArray[n3++] : (byte)0;
            byte by3 = n3 < n ? byArray[n3++] : (byte)0;
            int n4 = 63;
            cArray[n2++] = ALPHABET[by >> 2 & n4];
            cArray[n2++] = ALPHABET[(by << 4 | (by2 & 0xFF) >> 4) & n4];
            cArray[n2++] = ALPHABET[(by2 << 2 | (by3 & 0xFF) >> 6) & n4];
            cArray[n2++] = ALPHABET[by3 & n4];
        }
        switch (n % 3) {
            case 1: {
                cArray[--n2] = 61;
            }
            case 2: {
                cArray[--n2] = 61;
            }
        }
        return new String(cArray).replaceAll("g==", "s");
    }

    public int getBaseTemperature(World world) {
        if (!this.currentbasetemperature.containsKey(world)) {
            this.setBaseTemperature(world, this.main.getTemperatureManager().getTempUtils().generateNewBaseTemperature(world));
        }
        return this.currentbasetemperature.get(world);
    }

    public Long getLastDrink(Player player) {
        if (this.lastWaterBottleDrinked.containsKey(player.getUniqueId())) {
            return this.lastWaterBottleDrinked.get(player.getUniqueId());
        }
        return 0L;
    }

    public void drinked(Player player) {
        this.lastWaterBottleDrinked.put(player.getUniqueId(), System.currentTimeMillis());
    }

    public void setWaterModifier(Player player, Integer n) {
        this.waterModifier.put(player.getUniqueId(), n);
    }

    public int getWaterModifier(Player player) {
        if (!this.waterModifier.containsKey(player.getUniqueId())) {
            return 0;
        }
        return this.waterModifier.get(player.getUniqueId());
    }

    public int getSprintingModifier(Player player) {
        if (!this.sprintingModifier.containsKey(player.getUniqueId())) {
            return 0;
        }
        return this.sprintingModifier.get(player.getUniqueId());
    }

    public void setSprintingModifier(Player player, Integer n) {
        this.sprintingModifier.put(player.getUniqueId(), n);
    }

    public void removeFromWaterList(Player player) {
        this.waterModifier.remove(player.getUniqueId());
    }

    public boolean load() {
        InputStream inputStream;
        File file = new File(this.main.getDataFolder(), "temperature.yml");
        if (!file.exists()) {
            inputStream = this.main.getResource("temperature.yml");
            try {
                FileUtils.copyInputStreamToFile(inputStream, file);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        JavaUtils.saveDefaultConfigValues("/temperature.yml", "temperature.yml");
        inputStream = YamlConfiguration.loadConfiguration((File)file);
        if (!inputStream.getBoolean("enabled")) {
            this.isEnabled = false;
            return false;
        }
        this.tempsettings = new TemperatureSettings((YamlConfiguration)inputStream);
        this.isEnabled = true;
        return true;
    }

    private int getBiomeTemperatureModifierFromName(String string) {
        for (String string2 : this.biometemperatures.keySet()) {
            if (!string2.toLowerCase().equals(string.toLowerCase())) continue;
            return this.biometemperatures.get(string2);
        }
        return 0;
    }

    public int getBiomeTemperatureModifier(Location location) {
        String string = this.main.getNMSUtils().getBiomeName(location);
        return this.getBiomeTemperatureModifierFromName(string);
    }

    public void addBiomeTemperature(String string, Integer n) {
        this.biometemperatures.put(string, n);
    }

    public void addWaterBiomeTemperature(String string, HashMap<Season, Integer> hashMap) {
        this.watertemperatures.put(string, hashMap);
    }

    public int getWaterTemperatureModifier(Location location, Season season) {
        String string = this.main.getNMSUtils().getBiomeName(location);
        return this.getWaterTemperatureModifierFromName(string, season);
    }

    private int getWaterTemperatureModifierFromName(String string, Season season) {
        for (String string2 : this.watertemperatures.keySet()) {
            if (!string2.toLowerCase().equals(string.toLowerCase())) continue;
            return this.watertemperatures.get(string2).get((Object)season);
        }
        return 5555;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public TemperatureSettings getTempSettings() {
        return this.tempsettings;
    }

    public void toggleTemperature(World world) {
        if (this.isEnabledWorld(world)) {
            this.disableWorld(world);
        } else {
            this.enableWorld(world);
        }
    }

    public void removeIfDrinked(Player player) {
        if (this.lastWaterBottleDrinked.containsKey(player.getUniqueId())) {
            this.lastWaterBottleDrinked.remove(player.getUniqueId());
        }
    }

    static {
        for (int i = 0; i < ALPHABET.length; ++i) {
            TempData.toInt[TempData.ALPHABET[i]] = i;
        }
    }

    public class CustomTemperatureEffect {
        private int duration;
        private long startTime;
        private int temperatureModifier;

        public CustomTemperatureEffect(int n, int n2) {
            this.duration = n2;
            this.startTime = System.currentTimeMillis();
            this.temperatureModifier = n;
        }

        public CustomTemperatureEffect(int n, int n2, long l) {
            this.duration = n2;
            this.startTime = l;
            this.temperatureModifier = n;
        }

        public int getTemperatureModifier() {
            return this.temperatureModifier;
        }

        public int getDuration() {
            return this.duration;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public boolean isActive() {
            return this.startTime + (long)(this.duration * 1000) > System.currentTimeMillis();
        }
    }
}

