/*
 * Decompiled with CFR 0.152.
 */
package me.casperge.realisticseasons.utils;

import java.util.List;
import java.util.Random;
import me.casperge.realisticseasons.RealisticSeasons;
import me.casperge.realisticseasons.season.Season;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Bee;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fox;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Snowman;
import org.bukkit.entity.Tameable;

public class AnimalUtils {
    private RealisticSeasons main;
    private static Random r = new Random();

    public AnimalUtils(RealisticSeasons realisticSeasons) {
        this.main = realisticSeasons;
    }

    public void checkRandomEntity(Season season, World world) {
        if (world.getEntities().size() > 0) {
            List list = world.getEntities();
            int n = 10;
            if (list.size() < 10) {
                n = list.size();
            }
            for (int i = 0; i < n; ++i) {
                Entity entity = (Entity)list.get(r.nextInt(list.size()));
                this.checkEntity(entity, season, false);
                list.remove(entity);
            }
        }
    }

    public void removeAllAnimals(Season season, World world) {
        for (Entity entity : world.getEntities()) {
            this.checkEntity(entity, season, false);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean checkEntity(Entity entity, Season season, boolean bl) {
        Tameable tameable;
        if (!entity.getScoreboardTags().contains("seasonal")) {
            return false;
        }
        if (!this.main.hasSeasons(entity.getLocation().getChunk().getX(), entity.getLocation().getChunk().getZ(), entity.getLocation().getWorld())) {
            return false;
        }
        if (season == Season.DISABLED || season == null || entity.getCustomName() != null) return false;
        if (entity instanceof Tameable && (tameable = (Tameable)entity).getOwner() != null) {
            return false;
        }
        if (season != Season.SUMMER && this.main.getSettings().fullSummerAnimals.contains(entity.getType())) {
            entity.remove();
            return false;
        }
        if (season != Season.WINTER && this.main.getSettings().fullWinterAnimals.contains(entity.getType())) {
            if (entity.getType() != EntityType.WOLF && entity.getType() != EntityType.FOX) {
                entity.remove();
                return false;
            }
            if (entity.getType() != EntityType.FOX) {
                entity.remove();
                return false;
            }
            if (((Fox)entity).getFoxType() == Fox.Type.SNOW) {
                entity.remove();
                return false;
            }
        }
        if (season != Season.FALL && this.main.getSettings().fullFallAnimals.contains(entity.getType())) {
            if (entity.getType() != EntityType.FOX) {
                entity.remove();
                return false;
            }
            if (((Fox)entity).getFoxType() == Fox.Type.RED) {
                entity.remove();
                return false;
            }
        }
        if (season == Season.SPRING || !this.main.getSettings().fullSpringAnimals.contains(entity.getType())) return true;
        if (entity instanceof Bee) {
            tameable = (Bee)entity;
            if (tameable.getHive() != null) return true;
            entity.remove();
            return false;
        } else {
            if (entity.getType() != EntityType.COW && entity.getType() != EntityType.CHICKEN && entity.getType() != EntityType.SHEEP && entity.getType() != EntityType.PIG) {
                entity.remove();
                return false;
            }
            entity.remove();
            return false;
        }
    }

    public static boolean generateInGroups(EntityType entityType) {
        switch (entityType) {
            case FOX: {
                return false;
            }
            case MUSHROOM_COW: {
                return false;
            }
            case BEE: {
                return true;
            }
            case RABBIT: {
                return true;
            }
            case OCELOT: {
                return false;
            }
            case PANDA: {
                return false;
            }
            case PARROT: {
                return true;
            }
            case WOLF: {
                return true;
            }
            case POLAR_BEAR: {
                return false;
            }
            case SNOWMAN: {
                return false;
            }
        }
        return false;
    }

    public void generateAnimal(Chunk chunk, EntityType entityType, Season season) {
        boolean bl = false;
        for (Entity entity : chunk.getWorld().getNearbyEntities(chunk.getWorld().getHighestBlockAt(chunk.getBlock(7, 0, 7).getLocation()).getLocation(), 40.0, 40.0, 40.0)) {
            if (!this.checkEntity(entity, season, false)) continue;
            bl = true;
        }
        if (bl) {
            return;
        }
        int n = AnimalUtils.generateInGroups(entityType) ? r.nextInt(5) + 2 : 1;
        if (AnimalUtils.hasMultipleSeasonAnimals(chunk)) {
            return;
        }
        if ((entityType == EntityType.COW || entityType == EntityType.CHICKEN || entityType == EntityType.SHEEP || entityType == EntityType.PIG) && this.main.getSettings().spawnExtraAnimalsInSpring) {
            for (int i = 0; i <= 5; ++i) {
                LivingEntity livingEntity;
                Location location;
                if (i == 1) {
                    location = chunk.getWorld().getHighestBlockAt(chunk.getBlock(r.nextInt(16), 64, r.nextInt(16)).getLocation()).getRelative(BlockFace.UP).getLocation();
                    if (!this.isSpawnable(location.getBlock().getRelative(BlockFace.DOWN).getType())) continue;
                    livingEntity = (LivingEntity)chunk.getWorld().spawnEntity(location, entityType);
                    livingEntity.addScoreboardTag("seasonal");
                    continue;
                }
                location = chunk.getWorld().getHighestBlockAt(chunk.getBlock(r.nextInt(16), 64, r.nextInt(16)).getLocation()).getRelative(BlockFace.UP).getLocation();
                if (!this.isSpawnable(location.getBlock().getRelative(BlockFace.DOWN).getType())) continue;
                livingEntity = (Ageable)chunk.getWorld().spawnEntity(location, entityType);
                livingEntity.setBaby();
                livingEntity.addScoreboardTag("seasonal");
            }
        } else {
            for (int i = 1; i <= n; ++i) {
                Location location = chunk.getWorld().getHighestBlockAt(chunk.getBlock(r.nextInt(16), 64, r.nextInt(16)).getLocation()).getRelative(BlockFace.UP).getLocation();
                if (!this.isSpawnable(location.getBlock().getRelative(BlockFace.DOWN).getType())) continue;
                Entity entity = chunk.getWorld().spawnEntity(location, entityType);
                if (entity.getType() == EntityType.SNOWMAN) {
                    if (!this.main.getSettings().snowmanWearPumpkin) {
                        Snowman snowman = (Snowman)entity;
                        snowman.setDerp(true);
                    }
                } else if (entity.getType() == EntityType.FOX) {
                    if (season == Season.WINTER) {
                        ((Fox)entity).setFoxType(Fox.Type.SNOW);
                    } else {
                        ((Fox)entity).setFoxType(Fox.Type.RED);
                    }
                }
                entity.addScoreboardTag("seasonal");
            }
        }
    }

    public void updateAnimalSpawns(Season season, Chunk chunk) {
        if (!this.main.hasMobSpawns(chunk.getX(), chunk.getZ(), chunk.getWorld())) {
            return;
        }
        if (!this.main.getSettings().fallAnimals.isEmpty()) {
            if (season == Season.FALL) {
                if (Math.random() * 100.0 < (double)this.main.getSettings().spawnChanceAnimals && this.main.getSettings().fallAnimals.size() > 0) {
                    this.generateAnimal(chunk, this.main.getSettings().fallAnimals.get(r.nextInt(this.main.getSettings().fallAnimals.size())), Season.FALL);
                }
            } else if (season == Season.SPRING) {
                if (Math.random() * 100.0 < (double)this.main.getSettings().spawnChanceAnimals && this.main.getSettings().springAnimals.size() > 0) {
                    this.generateAnimal(chunk, this.main.getSettings().springAnimals.get(r.nextInt(this.main.getSettings().springAnimals.size())), Season.SPRING);
                }
            } else if (season == Season.SUMMER) {
                if (Math.random() * 100.0 < (double)this.main.getSettings().spawnChanceAnimals && this.main.getSettings().summerAnimals.size() > 0) {
                    this.generateAnimal(chunk, this.main.getSettings().summerAnimals.get(r.nextInt(this.main.getSettings().summerAnimals.size())), Season.SUMMER);
                }
            } else if (season == Season.WINTER && Math.random() * 100.0 < (double)this.main.getSettings().spawnChanceAnimals && this.main.getSettings().winterAnimals.size() > 0) {
                this.generateAnimal(chunk, this.main.getSettings().winterAnimals.get(r.nextInt(this.main.getSettings().winterAnimals.size())), Season.WINTER);
            }
        }
    }

    public boolean isSpawnable(Material material) {
        return material == Material.GRASS_BLOCK || material == Material.GRASS || material == Material.TALL_GRASS || material == Material.STONE || material == Material.SAND || material.toString().contains("TERRACOTTA") || material == Material.MYCELIUM;
    }

    private static boolean hasMultipleSeasonAnimals(Chunk chunk) {
        int n = 0;
        for (Entity entity : chunk.getEntities()) {
            if (!entity.getScoreboardTags().contains("seasonal") || ++n <= 1) continue;
            return true;
        }
        return false;
    }
}

