/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOExceptionList;
import org.apache.commons.io.IOIndexedException;

public class FilterCollectionWriter
extends Writer {
    protected final Collection<Writer> EMPTY_WRITERS = Collections.emptyList();
    protected final Collection<Writer> writers;

    protected FilterCollectionWriter(Collection<Writer> collection) {
        this.writers = collection == null ? this.EMPTY_WRITERS : collection;
    }

    protected FilterCollectionWriter(Writer ... writerArray) {
        this.writers = writerArray == null ? this.EMPTY_WRITERS : Arrays.asList(writerArray);
    }

    private List<Exception> add(List<Exception> list, int n, IOException iOException) {
        if (list == null) {
            list = new ArrayList<Exception>();
        }
        list.add(new IOIndexedException(n, (Throwable)iOException));
        return list;
    }

    @Override
    public Writer append(char c2) {
        List<Exception> list = null;
        int n = 0;
        for (Writer writer : this.writers) {
            if (writer != null) {
                try {
                    writer.append(c2);
                }
                catch (IOException iOException) {
                    list = this.add(list, n, iOException);
                }
            }
            ++n;
        }
        if (this.notEmpty(list)) {
            throw new IOExceptionList("append", list);
        }
        return this;
    }

    @Override
    public Writer append(CharSequence charSequence) {
        List<Exception> list = null;
        int n = 0;
        for (Writer writer : this.writers) {
            if (writer != null) {
                try {
                    writer.append(charSequence);
                }
                catch (IOException iOException) {
                    list = this.add(list, n, iOException);
                }
            }
            ++n;
        }
        if (this.notEmpty(list)) {
            throw new IOExceptionList("append", list);
        }
        return this;
    }

    @Override
    public Writer append(CharSequence charSequence, int n, int n2) {
        List<Exception> list = null;
        int n3 = 0;
        for (Writer writer : this.writers) {
            if (writer != null) {
                try {
                    writer.append(charSequence, n, n2);
                }
                catch (IOException iOException) {
                    list = this.add(list, n3, iOException);
                }
            }
            ++n3;
        }
        if (this.notEmpty(list)) {
            throw new IOExceptionList("append", list);
        }
        return this;
    }

    @Override
    public void close() {
        List<Exception> list = null;
        int n = 0;
        for (Writer writer : this.writers) {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {
                    list = this.add(list, n, iOException);
                }
            }
            ++n;
        }
        if (this.notEmpty(list)) {
            throw new IOExceptionList("close", list);
        }
    }

    @Override
    public void flush() {
        List<Exception> list = null;
        int n = 0;
        for (Writer writer : this.writers) {
            if (writer != null) {
                try {
                    writer.flush();
                }
                catch (IOException iOException) {
                    list = this.add(list, n, iOException);
                }
            }
            ++n;
        }
        if (this.notEmpty(list)) {
            throw new IOExceptionList("flush", list);
        }
    }

    private boolean notEmpty(List<Exception> list) {
        return list != null && !list.isEmpty();
    }

    @Override
    public void write(char[] cArray) {
        List<Exception> list = null;
        int n = 0;
        for (Writer writer : this.writers) {
            if (writer != null) {
                try {
                    writer.write(cArray);
                }
                catch (IOException iOException) {
                    list = this.add(list, n, iOException);
                }
            }
            ++n;
        }
        if (this.notEmpty(list)) {
            throw new IOExceptionList("write", list);
        }
    }

    @Override
    public void write(char[] cArray, int n, int n2) {
        List<Exception> list = null;
        int n3 = 0;
        for (Writer writer : this.writers) {
            if (writer != null) {
                try {
                    writer.write(cArray, n, n2);
                }
                catch (IOException iOException) {
                    list = this.add(list, n3, iOException);
                }
            }
            ++n3;
        }
        if (this.notEmpty(list)) {
            throw new IOExceptionList("write", list);
        }
    }

    @Override
    public void write(int n) {
        List<Exception> list = null;
        int n2 = 0;
        for (Writer writer : this.writers) {
            if (writer != null) {
                try {
                    writer.write(n);
                }
                catch (IOException iOException) {
                    list = this.add(list, n2, iOException);
                }
            }
            ++n2;
        }
        if (this.notEmpty(list)) {
            throw new IOExceptionList("write", list);
        }
    }

    @Override
    public void write(String string) {
        List<Exception> list = null;
        int n = 0;
        for (Writer writer : this.writers) {
            if (writer != null) {
                try {
                    writer.write(string);
                }
                catch (IOException iOException) {
                    list = this.add(list, n, iOException);
                }
            }
            ++n;
        }
        if (this.notEmpty(list)) {
            throw new IOExceptionList("write", list);
        }
    }

    @Override
    public void write(String string, int n, int n2) {
        List<Exception> list = null;
        int n3 = 0;
        for (Writer writer : this.writers) {
            if (writer != null) {
                try {
                    writer.write(string, n, n2);
                }
                catch (IOException iOException) {
                    list = this.add(list, n3, iOException);
                }
            }
            ++n3;
        }
        if (this.notEmpty(list)) {
            throw new IOExceptionList("write", list);
        }
    }
}

