/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes;

import com.xericker.mysteryboxes.Depend;
import com.xericker.mysteryboxes.Expansion;
import com.xericker.mysteryboxes.Main;
import com.xericker.mysteryboxes.Updater;
import com.xericker.mysteryboxes.commands.CommandEvent;
import com.xericker.mysteryboxes.commands.CommandTabs;
import com.xericker.mysteryboxes.compiled.bukkit.Metrics;
import com.xericker.mysteryboxes.config.files.ConfigValue;
import com.xericker.mysteryboxes.config.files.LanguageValue;
import com.xericker.mysteryboxes.config.handlers.ConfigFile;
import com.xericker.mysteryboxes.config.handlers.ConfigParser;
import com.xericker.mysteryboxes.core.events.opening.OpenEvent;
import com.xericker.mysteryboxes.core.songpack.SongPackEvent;
import com.xericker.mysteryboxes.core.vaults.VaultData;
import com.xericker.mysteryboxes.core.vaults.holograms.Hologram;
import com.xericker.mysteryboxes.core.vaults.holograms.HologramData;
import com.xericker.mysteryboxes.events.EventEntityBlockForm;
import com.xericker.mysteryboxes.events.EventEntityDamage;
import com.xericker.mysteryboxes.events.EventEntityDamageByEntity;
import com.xericker.mysteryboxes.events.EventEntityExplode;
import com.xericker.mysteryboxes.events.EventEntityPickupItem;
import com.xericker.mysteryboxes.events.EventEntityTarget;
import com.xericker.mysteryboxes.events.EventItemMerge;
import com.xericker.mysteryboxes.events.EventPlayerArmorStandManipulate;
import com.xericker.mysteryboxes.events.EventPlayerInteract;
import com.xericker.mysteryboxes.events.EventPlayerInteractAtEntity;
import com.xericker.mysteryboxes.events.EventPlayerInteractEntity;
import com.xericker.mysteryboxes.events.EventPlayerJoin;
import com.xericker.mysteryboxes.events.EventPlayerQuit;
import com.xericker.mysteryboxes.handlers.data.boxes.BoxManager;
import com.xericker.mysteryboxes.handlers.data.loots.LootManager;
import com.xericker.mysteryboxes.handlers.data.songs.SongManager;
import com.xericker.mysteryboxes.handlers.data.themes.ThemeManager;
import com.xericker.mysteryboxes.handlers.data.upgrades.UpgradeManager;
import com.xericker.mysteryboxes.handlers.economy.EconomyHandler;
import com.xericker.mysteryboxes.menus.Menu;
import com.xericker.mysteryboxes.menus.MenuEvents;
import com.xericker.mysteryboxes.menus.MenuTask;
import com.xericker.mysteryboxes.menus.menus.alertsvisibility.MenuEventAlertsVisibility;
import com.xericker.mysteryboxes.menus.menus.craftboxes.MenuEventCraftBoxes;
import com.xericker.mysteryboxes.menus.menus.customizeopening.MenuEventCustomizeOpening;
import com.xericker.mysteryboxes.menus.menus.history.MenuEventHistory;
import com.xericker.mysteryboxes.menus.menus.openboxes.MenuEventOpenBoxes;
import com.xericker.mysteryboxes.menus.menus.sendgifts.MenuEventSendGifts;
import com.xericker.mysteryboxes.menus.menus.songs.MenuEventSongs;
import com.xericker.mysteryboxes.menus.menus.themes.MenuEventThemes;
import com.xericker.mysteryboxes.menus.menus.upgrades.MenuEventUpgrades;
import com.xericker.mysteryboxes.menus.menus.vault.MenuEventVault;
import com.xericker.mysteryboxes.menus.menus.vaultmanager.MenuEventVaultManager;
import com.xericker.mysteryboxes.menus.menus.yourprofile.MenuEventYourProfile;
import com.xericker.mysteryboxes.mysql.SQLConnection;
import com.xericker.mysteryboxes.playerdata.player.PlayerData;
import com.xericker.mysteryboxes.playerdata.player.PlayerDataManager;
import libraries.ProgressBar;
import misc.KFormatter;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Item;
import org.bukkit.event.Listener;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.PluginManager;
import utils.WorldUtils;

public class Plugin {
    private static Updater updater;
    public static KFormatter kFormatter;
    private static SQLConnection sqlConnection;
    private static EconomyHandler economyHandler;
    private static ProgressBar progressBar;

    private Plugin() {
    }

    public static boolean registerPlugin() {
        try {
            if (!Plugin.validateDepends()) {
                return false;
            }
            if (System.getProperty(Main.getPlugin().getDescription().getName() + "Loaded") != null) {
                Main.getPlugin().getLogger().warning("Please keep in mind that reloading the plugin may cause bugs.");
                Main.getPlugin().getLogger().warning("It is recommended to restart your server to apply changes.");
            }
            System.setProperty(Main.getPlugin().getDescription().getName() + "Loaded", "true");
            if (!Plugin.registerCommands()) {
                Main.getPlugin().getLogger().warning("Failed to register commands. Disabling the plugin...");
                return false;
            }
            if (!Plugin.registerEvents()) {
                Main.getPlugin().getLogger().warning("Failed to register events. Disabling the plugin...");
                return false;
            }
            economyHandler = new EconomyHandler();
            kFormatter = new KFormatter(ConfigParser.getBoolean(ConfigValue.SHORT_NUMBER_FORMAT));
            new Metrics(Main.getPlugin(), 6820);
            new MenuTask().runTaskTimerAsynchronously((org.bukkit.plugin.Plugin)Main.getPlugin(), 0L, 10L);
            ConfigFile.registerFiles();
            Menu.registerFiles();
            ThemeManager.registerData();
            SongManager.registerData();
            UpgradeManager.registerData();
            LootManager.registerData();
            BoxManager.registerData();
            HologramData.registerTask();
            String string = ConfigParser.getString(LanguageValue.PROGRESS_BAR);
            String string2 = ConfigParser.getString(LanguageValue.PROGRESS_BAR_PROGRESS_COLOR);
            String string3 = ConfigParser.getString(LanguageValue.PROGRESS_BAR_REMAINING_COLOR);
            progressBar = new ProgressBar(string, string2, string3);
            if (Boolean.TRUE.equals(ConfigParser.getBoolean(ConfigValue.CHECK_FOR_UPDATES))) {
                updater = new Updater(12330);
            }
            if (Boolean.TRUE.equals(ConfigParser.getBoolean(ConfigValue.MYSQL_ENABLED))) {
                sqlConnection = new SQLConnection();
                sqlConnection.openConnection();
            }
            if (Depend.PLACEHOLDER_API.isLoaded()) {
                Expansion expansion = new Expansion();
                if (expansion.isRegistered()) {
                    expansion.unregister();
                }
                expansion.register();
            }
            return true;
        }
        catch (Exception exception) {
            Main.getPlugin().getLogger().warning("Failed to register the plugin.");
            exception.printStackTrace();
            return false;
        }
    }

    public static boolean unregisterPlugin() {
        try {
            for (int i = 0; i < PlayerDataManager.getDataList().size(); ++i) {
                PlayerData playerData = PlayerDataManager.getDataList().get(i);
                OpenEvent openEvent = playerData.getOpenExecutor();
                if (openEvent != null && !openEvent.shouldContinue()) {
                    openEvent.removeLeftovers();
                }
                PlayerDataManager.saveData(playerData, false, true);
            }
            NamespacedKey namespacedKey = new NamespacedKey((org.bukkit.plugin.Plugin)Main.getPlugin(), "mysteryvault");
            Bukkit.getWorlds().forEach(world -> world.getEntitiesByClasses(new Class[]{Item.class, ExperienceOrb.class, ArmorStand.class}).stream().filter(entity -> entity.hasMetadata(Main.getMetadataValue()) || entity.getPersistentDataContainer().has(namespacedKey, PersistentDataType.STRING)).forEach(Entity::remove));
            VaultData.getList().forEach(vault -> vault.getHolograms().forEach(Hologram::remove));
            VaultData.getList().forEach(vault -> Bukkit.getOnlinePlayers().forEach(player -> WorldUtils.sendChestAction(player, vault.getVaultLoc(), 0)));
            SongManager.getList().forEach(songData -> Bukkit.getOnlinePlayers().forEach(player -> player.stopSound(songData.getSongId().toLowerCase())));
            return true;
        }
        catch (Exception exception) {
            Main.getPlugin().getLogger().warning("Failed to unregister the plugin.");
            exception.printStackTrace();
            return false;
        }
    }

    private static boolean registerEvents() {
        try {
            PluginManager pluginManager = Bukkit.getPluginManager();
            pluginManager.registerEvents((Listener)new EventPlayerQuit(), (org.bukkit.plugin.Plugin)Main.getPlugin());
            pluginManager.registerEvents((Listener)new EventPlayerJoin(), (org.bukkit.plugin.Plugin)Main.getPlugin());
            pluginManager.registerEvents((Listener)new EventPlayerInteractEntity(), (org.bukkit.plugin.Plugin)Main.getPlugin());
            pluginManager.registerEvents((Listener)new EventPlayerInteractAtEntity(), (org.bukkit.plugin.Plugin)Main.getPlugin());
            pluginManager.registerEvents((Listener)new EventPlayerInteract(), (org.bukkit.plugin.Plugin)Main.getPlugin());
            pluginManager.registerEvents((Listener)new EventPlayerArmorStandManipulate(), (org.bukkit.plugin.Plugin)Main.getPlugin());
            pluginManager.registerEvents((Listener)new EventItemMerge(), (org.bukkit.plugin.Plugin)Main.getPlugin());
            pluginManager.registerEvents((Listener)new EventEntityTarget(), (org.bukkit.plugin.Plugin)Main.getPlugin());
            pluginManager.registerEvents((Listener)new EventEntityPickupItem(), (org.bukkit.plugin.Plugin)Main.getPlugin());
            pluginManager.registerEvents((Listener)new EventEntityExplode(), (org.bukkit.plugin.Plugin)Main.getPlugin());
            pluginManager.registerEvents((Listener)new EventEntityDamageByEntity(), (org.bukkit.plugin.Plugin)Main.getPlugin());
            pluginManager.registerEvents((Listener)new EventEntityDamage(), (org.bukkit.plugin.Plugin)Main.getPlugin());
            pluginManager.registerEvents((Listener)new EventEntityBlockForm(), (org.bukkit.plugin.Plugin)Main.getPlugin());
            pluginManager.registerEvents((Listener)new MenuEvents(), (org.bukkit.plugin.Plugin)Main.getPlugin());
            pluginManager.registerEvents((Listener)new SongPackEvent(), (org.bukkit.plugin.Plugin)Main.getPlugin());
            pluginManager.registerEvents((Listener)new MenuEventVault(), (org.bukkit.plugin.Plugin)Main.getPlugin());
            pluginManager.registerEvents((Listener)new MenuEventVaultManager(), (org.bukkit.plugin.Plugin)Main.getPlugin());
            pluginManager.registerEvents((Listener)new MenuEventOpenBoxes(), (org.bukkit.plugin.Plugin)Main.getPlugin());
            pluginManager.registerEvents((Listener)new MenuEventCustomizeOpening(), (org.bukkit.plugin.Plugin)Main.getPlugin());
            pluginManager.registerEvents((Listener)new MenuEventThemes(), (org.bukkit.plugin.Plugin)Main.getPlugin());
            pluginManager.registerEvents((Listener)new MenuEventSongs(), (org.bukkit.plugin.Plugin)Main.getPlugin());
            pluginManager.registerEvents((Listener)new MenuEventYourProfile(), (org.bukkit.plugin.Plugin)Main.getPlugin());
            pluginManager.registerEvents((Listener)new MenuEventHistory(), (org.bukkit.plugin.Plugin)Main.getPlugin());
            pluginManager.registerEvents((Listener)new MenuEventCraftBoxes(), (org.bukkit.plugin.Plugin)Main.getPlugin());
            pluginManager.registerEvents((Listener)new MenuEventSendGifts(), (org.bukkit.plugin.Plugin)Main.getPlugin());
            pluginManager.registerEvents((Listener)new MenuEventUpgrades(), (org.bukkit.plugin.Plugin)Main.getPlugin());
            pluginManager.registerEvents((Listener)new MenuEventAlertsVisibility(), (org.bukkit.plugin.Plugin)Main.getPlugin());
            return true;
        }
        catch (Exception exception) {
            Main.getPlugin().getLogger().warning("Failed to register events.");
            exception.printStackTrace();
            return false;
        }
    }

    private static boolean registerCommands() {
        try {
            PluginCommand pluginCommand = Main.getPlugin().getCommand("mysteryboxes");
            if (pluginCommand == null) {
                return false;
            }
            pluginCommand.setExecutor((CommandExecutor)new CommandEvent());
            pluginCommand.setTabCompleter((TabCompleter)new CommandTabs());
            return true;
        }
        catch (Exception exception) {
            Main.getPlugin().getLogger().warning("Failed to register commands.");
            exception.printStackTrace();
            return false;
        }
    }

    private static boolean validateDepends() {
        try {
            Depend[] dependArray = new Depend[]{Depend.PROTOCOL_LIB};
            boolean bl = true;
            for (Depend depend : dependArray) {
                if (depend.isLoaded()) continue;
                Main.getPlugin().getLogger().warning(String.format("%s is a required dependency for this plugin!", depend.getName()));
                Main.getPlugin().getLogger().warning(String.format("Install the latest version from: %s", depend.getLink()));
                bl = false;
            }
            return bl;
        }
        catch (Exception exception) {
            Main.getPlugin().getLogger().warning("Failed to validate depends.");
            exception.printStackTrace();
            return false;
        }
    }

    public static Updater getUpdater() {
        return updater;
    }

    public static KFormatter getNumFormat() {
        return kFormatter;
    }

    public static SQLConnection getSQLConnection() {
        return sqlConnection;
    }

    public static EconomyHandler getEconomyManager() {
        return economyHandler;
    }

    public static ProgressBar getProgressBar() {
        return progressBar;
    }
}

