/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.commands.executors.boxes;

import com.xericker.mysteryboxes.Main;
import com.xericker.mysteryboxes.commands.Command;
import com.xericker.mysteryboxes.commands.CommandInterface;
import com.xericker.mysteryboxes.commands.CommandUtils;
import com.xericker.mysteryboxes.config.files.LanguageValue;
import com.xericker.mysteryboxes.config.handlers.ConfigParser;
import com.xericker.mysteryboxes.handlers.data.boxes.Box;
import com.xericker.mysteryboxes.handlers.data.boxes.BoxManager;
import com.xericker.mysteryboxes.handlers.placeholders.GeneralPlaceholders;
import com.xericker.mysteryboxes.playerdata.player.PlayerData;
import com.xericker.mysteryboxes.playerdata.player.PlayerDataManager;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import utils.PluginUtils;

public class ExecuteGiftUpdater
implements CommandInterface {
    @Override
    public boolean execute(CommandSender commandSender, Command command, String[] stringArray) {
        if (stringArray.length < 4) {
            CommandUtils.sendMessage(commandSender, "Oops! Some arguments are missing!", command);
            return false;
        }
        if (!PluginUtils.isInteger(stringArray[3])) {
            CommandUtils.sendMessage(commandSender, "The [amount] argument must be a number!", command);
            return false;
        }
        Box box = BoxManager.getBox(stringArray[2]);
        if (box == null) {
            CommandUtils.sendMessage(commandSender, new String[]{"Could not find the specified box!", "", "\u00a7eType \u00a7b/mb " + Command.LISTBOXES.getName() + " \u00a7efor the list of Mystery Boxes"});
            return false;
        }
        int n = Integer.parseInt(stringArray[3]);
        PlayerData playerData = CommandUtils.getPlayerData(commandSender, stringArray[1]);
        if (playerData == null) {
            return false;
        }
        Player player = Bukkit.getPlayer((UUID)playerData.getPlayerId());
        String string = player != null ? player.getName() : stringArray[1];
        long l = System.currentTimeMillis();
        if (!playerData.isDataSynced()) {
            CommandUtils.sendDataFetchStart(commandSender);
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Main.getPlugin(), () -> {
            do {
                long l2;
                if ((l2 = System.currentTimeMillis()) - l < 5000L) continue;
                CommandUtils.sendDataFetchFail(commandSender);
                return;
            } while (!playerData.isDataSynced());
            List<Object> list = new ArrayList();
            switch (command) {
                case SETGIFTS: {
                    playerData.setGifts(box, n);
                    list = ConfigParser.getStringList(LanguageValue.GIFTING_SET);
                    break;
                }
                case ADDGIFTS: {
                    playerData.setGifts(box, playerData.getGifts(box) + n);
                    list = ConfigParser.getStringList(LanguageValue.GIFTING_ADD);
                    break;
                }
                case REMOVEGIFTS: {
                    playerData.setGifts(box, playerData.getGifts(box) - n);
                    list = ConfigParser.getStringList(LanguageValue.GIFTING_REMOVE);
                }
            }
            for (String string2 : list) {
                string2 = GeneralPlaceholders.translate((Object)playerData.getPlayerId(), string2);
                string2 = string2.replace("{PLAYER}", string);
                string2 = string2.replace("{AMOUNT}", String.valueOf(n));
                commandSender.sendMessage(string2);
            }
            if (player == null) {
                PlayerDataManager.saveData(playerData, true, true);
            }
        });
        return false;
    }
}

