/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.commands.executors.songs;

import com.xericker.mysteryboxes.Variables;
import com.xericker.mysteryboxes.commands.Command;
import com.xericker.mysteryboxes.commands.CommandInterface;
import com.xericker.mysteryboxes.handlers.data.songs.SongData;
import com.xericker.mysteryboxes.handlers.data.songs.SongManager;
import com.xericker.mysteryboxes.handlers.data.songs.SongStatus;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.command.CommandSender;
import utils.MessageUtils;

public class ExecuteSongList
implements CommandInterface {
    @Override
    public boolean execute(CommandSender commandSender, Command command, String[] stringArray) {
        TextComponent textComponent = new TextComponent(MessageUtils.formatCenter("\u00a76\u00a7nClick\u00a7e to learn about Jukebox Songs"));
        textComponent.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://bit.ly/3HKBlLF"));
        textComponent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a76\u00a7nClick\u00a7e to open the wiki").create()));
        commandSender.sendMessage(MessageUtils.getSeparator(Variables.SEPARATOR_COLOR));
        commandSender.sendMessage("");
        commandSender.sendMessage(MessageUtils.formatCenter("\u00a7r\u00a7lJukebox Songs"));
        commandSender.sendMessage("");
        if (SongManager.getList().isEmpty()) {
            commandSender.sendMessage(MessageUtils.formatCenter("\u00a7cThere are no Jukebox Songs registered!"));
            commandSender.sendMessage(" ");
        }
        for (SongData songData : SongManager.getList()) {
            Object object = "\u00a7a\u2714OK";
            if (!songData.getGeneralSettings().enabled) {
                object = "\u00a7c\u2716DISABLED";
            } else if (songData.getStatus() != SongStatus.ENABLED && songData.getGeneralSettings().enabled) {
                object = "\u00a7c\u2716" + songData.getStatus().name();
            }
            String string = "\u00a78\ud83d\udd38 \u00a7r" + songData.getSongId() + " \u00a78- " + (String)object;
            commandSender.sendMessage(string);
        }
        commandSender.sendMessage("");
        commandSender.spigot().sendMessage((BaseComponent)textComponent);
        commandSender.sendMessage("");
        commandSender.sendMessage(MessageUtils.getSeparator(Variables.SEPARATOR_COLOR));
        return false;
    }
}

