/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.core.events.opening.themes;

import com.xericker.mysteryboxes.Main;
import com.xericker.mysteryboxes.core.events.opening.OpenEvent;
import com.xericker.mysteryboxes.core.events.opening.themes.AnimationExecutor;
import com.xericker.mysteryboxes.core.events.opening.themes.ThemeExecutor;
import com.xericker.mysteryboxes.core.events.opening.themes.holiday.HolidaySong;
import com.xericker.mysteryboxes.core.events.opening.themes.standard.StandardAnimation;
import com.xericker.mysteryboxes.core.events.opening.themes.standard.StandardSong;
import com.xericker.mysteryboxes.handlers.data.themes.Theme;
import org.bukkit.entity.ArmorStand;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ThemeHandler {
    private OpenEvent openEvent;
    private Theme theme;
    private AnimationExecutor animationExecutor;
    private ThemeExecutor themeExecutor;
    private BukkitRunnable songTask;

    public ThemeHandler(OpenEvent openEvent) {
        this.openEvent = openEvent;
        this.theme = openEvent.getOpenData().forceTheme;
    }

    public void playTheme() {
        if (this.theme == null) {
            return;
        }
        this.themeExecutor = this.theme.getExecutor();
        if (this.themeExecutor != null) {
            this.themeExecutor.startTheme(this.openEvent);
        }
    }

    public void stopTheme() {
        if (this.themeExecutor == null) {
            return;
        }
        this.themeExecutor.stopTheme();
    }

    public AnimationExecutor getAnimation() {
        return this.animationExecutor;
    }

    public void playAnimation(ArmorStand armorStand) {
        this.animationExecutor = new StandardAnimation(this.openEvent, armorStand);
        ((BukkitRunnable)this.animationExecutor).runTaskTimer((Plugin)Main.getPlugin(), 5L, (long)this.openEvent.getOpenData().animationTaskPeriod);
    }

    public void playSong() {
        this.songTask = new StandardSong(this.openEvent);
        if (this.theme == Theme.HOLIDAY) {
            this.songTask = new HolidaySong(this.openEvent);
        }
        this.songTask.runTaskTimer((Plugin)Main.getPlugin(), 0L, (long)this.openEvent.getOpenData().musicTaskPeriod);
    }

    public void stopSong() {
        if (this.songTask == null) {
            return;
        }
        this.songTask.cancel();
    }
}

