/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.core.events.opening.themes.holiday;

import com.xericker.mysteryboxes.Main;
import com.xericker.mysteryboxes.core.events.opening.OpenEvent;
import com.xericker.mysteryboxes.core.events.opening.themes.ThemeExecutor;
import com.xericker.mysteryboxes.core.events.opening.utils.BoxEntity;
import com.xericker.mysteryboxes.core.vaults.VaultData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Slab;
import org.bukkit.block.data.type.Stairs;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.entity.Snowball;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import utils.LocationUtils;
import utils.PlayerUtils;
import utils.WorldUtils;

public class HolidayTheme
implements ThemeExecutor {
    private OpenEvent openEvent;
    private Location eventLocation;
    private Map<Block, Material> terrainBlocks;
    private List<Snowball> fallingSnowballs;
    private List<Snowball> deadSnowballs;
    private Map<ArmorStand, Double> particles;
    private Map<ArmorStand, Integer> circleIndexes;
    private List<Location> circleLocs;
    private final int VISIBILITY_RADIUS = 50;
    private final int CIRCLE_RADIUS = 4;
    private final int CIRCLE_POINTS = 50;

    @Override
    public void startTheme(OpenEvent openEvent) {
        this.openEvent = openEvent;
        this.generateTerrain();
    }

    @Override
    public void stopTheme() {
        for (Block block : this.terrainBlocks.keySet()) {
            block.getState().update();
        }
        for (Snowball snowball : this.fallingSnowballs) {
            snowball.remove();
        }
        for (ArmorStand armorStand : this.particles.keySet()) {
            armorStand.remove();
        }
    }

    public void generateTerrain() {
        this.terrainBlocks = new HashMap<Block, Material>();
        this.fallingSnowballs = new ArrayList<Snowball>();
        this.deadSnowballs = new ArrayList<Snowball>();
        this.eventLocation = this.openEvent.getEventLocation();
        if (this.openEvent.getOpenData().vault != null) {
            this.eventLocation.setY((double)this.eventLocation.getBlockY());
            this.eventLocation.subtract(0.0, 1.0, 0.0);
        }
        LocationUtils.setSolidBlock(this.eventLocation, BlockFace.DOWN);
        this.particles = new HashMap<ArmorStand, Double>();
        this.circleIndexes = new HashMap<ArmorStand, Integer>();
        this.circleLocs = LocationUtils.getCircle(this.eventLocation, 4.0, 50);
        new BukkitRunnable(){
            int terrainStep = 4;
            int terrainRadius = 3;

            public void run() {
                if (HolidayTheme.this.openEvent.isEventCancelled()) {
                    this.cancel();
                    return;
                }
                --this.terrainStep;
                if (this.terrainStep == 0) {
                    HolidayTheme.this.spawnParticles();
                    HolidayTheme.this.spawnSnowballs();
                    this.cancel();
                    return;
                }
                for (Block block : LocationUtils.getCube(HolidayTheme.this.eventLocation, this.terrainRadius)) {
                    if (HolidayTheme.this.terrainBlocks.containsKey(block) || block.isEmpty() || block.getLocation().getY() < HolidayTheme.this.eventLocation.getY() || VaultData.getVault(block.getRelative(BlockFace.UP).getLocation()) != null || VaultData.getVault(block.getLocation()) != null) continue;
                    Material material = Material.WARPED_PLANKS;
                    BlockData blockData = Bukkit.createBlockData((Material)material);
                    BlockData blockData2 = block.getBlockData();
                    if (blockData2 instanceof Slab) {
                        Slab slab = (Slab)blockData2;
                        material = Material.WARPED_SLAB;
                        blockData2 = (Slab)Bukkit.createBlockData((Material)material);
                        blockData2.setType(slab.getType());
                        blockData = blockData2;
                    } else {
                        blockData2 = block.getBlockData();
                        if (blockData2 instanceof Stairs) {
                            Stairs stairs = (Stairs)blockData2;
                            material = Material.WARPED_STAIRS;
                            blockData2 = (Stairs)Bukkit.createBlockData((Material)material);
                            blockData2.setShape(stairs.getShape());
                            blockData2.setFacing(stairs.getFacing());
                            blockData = blockData2;
                        }
                    }
                    WorldUtils.playStepSound(block.getLocation(), blockData.getMaterial(), 1);
                    for (Player player : PlayerUtils.getNearbyPlayers(HolidayTheme.this.eventLocation, 50.0)) {
                        player.sendBlockChange(block.getLocation(), blockData);
                    }
                    HolidayTheme.this.terrainBlocks.put(block, material);
                }
                this.terrainRadius += 2;
            }
        }.runTaskTimer((Plugin)Main.getPlugin(), 0L, 10L);
    }

    public void spawnSnowballs() {
        final ArrayList<Block> arrayList = new ArrayList<Block>();
        for (Block block : this.terrainBlocks.keySet()) {
            if (!block.getRelative(BlockFace.UP).isEmpty()) continue;
            arrayList.add(block);
        }
        new BukkitRunnable(){
            int spawnStep = -1;
            float soundPitch = 0.5f;
            Material material = Material.SNOW_BLOCK;
            BlockData blockData = Bukkit.createBlockData((Material)this.material);

            public void run() {
                Location location;
                Snowball snowball2;
                if (HolidayTheme.this.openEvent.isEventCancelled()) {
                    this.cancel();
                    return;
                }
                if (HolidayTheme.this.fallingSnowballs.size() > 0 && HolidayTheme.this.fallingSnowballs.size() == HolidayTheme.this.deadSnowballs.size()) {
                    for (Block block : arrayList) {
                        for (Player player : PlayerUtils.getNearbyPlayers(HolidayTheme.this.eventLocation, 50.0)) {
                            BlockData blockData = Bukkit.createBlockData((Material)this.material);
                            player.sendBlockChange(block.getLocation(), blockData);
                        }
                    }
                    this.cancel();
                    return;
                }
                for (Snowball snowball2 : HolidayTheme.this.fallingSnowballs) {
                    if (!snowball2.isDead()) {
                        snowball2.getWorld().spawnParticle(Particle.WAX_OFF, snowball2.getLocation(), 1, 0.0, 0.0, 0.0, 0.0);
                    }
                    if (!snowball2.isDead() || HolidayTheme.this.deadSnowballs.contains(snowball2)) continue;
                    HolidayTheme.this.deadSnowballs.add(snowball2);
                    location = snowball2.getLocation();
                    location.getWorld().spawnParticle(Particle.CLOUD, location, 5, 0.0, 0.0, 0.0, (double)0.15f);
                    for (Block block : LocationUtils.getCube(location, 3)) {
                        if (!HolidayTheme.this.terrainBlocks.containsKey(block)) continue;
                        for (Player player : Bukkit.getOnlinePlayers()) {
                            player.sendBlockChange(block.getLocation(), this.blockData);
                        }
                    }
                }
                this.spawnStep += 2;
                if (this.spawnStep >= arrayList.size()) {
                    return;
                }
                Block block = (Block)arrayList.get(this.spawnStep);
                snowball2 = block.getLocation();
                snowball2.add(0.0, 7.0, 0.0);
                location = (Snowball)HolidayTheme.this.eventLocation.getWorld().spawn((Location)snowball2, Snowball.class);
                location.setMetadata(Main.getMetadataValue(), (MetadataValue)Main.getFixedMetadataValue());
                location.setVelocity(new Vector(0.0, -0.5, 0.0));
                HolidayTheme.this.fallingSnowballs.add((Snowball)location);
                this.soundPitch = (float)((double)this.soundPitch + 0.1);
                location.getWorld().playSound(location.getLocation(), Sound.ENTITY_CHICKEN_EGG, 1.0f, this.soundPitch);
            }
        }.runTaskTimer((Plugin)Main.getPlugin(), 0L, 2L);
    }

    public void spawnParticles() {
        new BukkitRunnable(){
            int spawnStep = 1;

            public void run() {
                if (HolidayTheme.this.openEvent.isEventCancelled()) {
                    this.cancel();
                    return;
                }
                --this.spawnStep;
                if (this.spawnStep == 0) {
                    this.spawnStep = 4;
                    ArmorStand armorStand = (ArmorStand)HolidayTheme.this.eventLocation.getWorld().spawn(HolidayTheme.this.eventLocation, ArmorStand.class);
                    BoxEntity.updateEntity(armorStand);
                    HolidayTheme.this.particles.put(armorStand, 0.0);
                    HolidayTheme.this.circleIndexes.put(armorStand, Main.getRandom().nextInt(50));
                }
                for (ArmorStand armorStand : HolidayTheme.this.particles.keySet()) {
                    if (HolidayTheme.this.particles.get(armorStand) > 7.0) {
                        armorStand.remove();
                        continue;
                    }
                    int n = HolidayTheme.this.circleIndexes.get(armorStand);
                    HolidayTheme.this.circleIndexes.put(armorStand, n + 1);
                    if (HolidayTheme.this.circleIndexes.get(armorStand) == 50) {
                        HolidayTheme.this.circleIndexes.put(armorStand, 0);
                    }
                    HolidayTheme.this.particles.put(armorStand, HolidayTheme.this.particles.get(armorStand) + 0.15);
                    Location location = HolidayTheme.this.circleLocs.get(n).clone();
                    location.add(0.0, HolidayTheme.this.particles.get(armorStand).doubleValue(), 0.0);
                    armorStand.teleport(location);
                    armorStand.getWorld().spawnParticle(Particle.WAX_OFF, armorStand.getEyeLocation(), 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }.runTaskTimer((Plugin)Main.getPlugin(), 0L, 2L);
    }
}

