/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.core.events.opening.themes.standard;

import com.xericker.mysteryboxes.Main;
import com.xericker.mysteryboxes.core.events.opening.OpenEvent;
import com.xericker.mysteryboxes.core.events.opening.OpenEventData;
import com.xericker.mysteryboxes.core.events.opening.themes.AnimationExecutor;
import com.xericker.mysteryboxes.core.events.opening.utils.BoxEntity;
import com.xericker.mysteryboxes.handlers.data.loots.Loot;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import utils.LocationUtils;
import utils.WorldUtils;

public class StandardAnimation
extends BukkitRunnable
implements AnimationExecutor {
    private OpenEvent openEvent;
    private ArmorStand boxEntity;
    private Location centerLoc;
    private int animationStep = 0;
    private double circleSize = 0.0;
    private int circleStep = 0;
    public boolean idleParticles;

    public StandardAnimation(OpenEvent openEvent, ArmorStand armorStand) {
        this.openEvent = openEvent;
        this.boxEntity = armorStand;
        this.centerLoc = armorStand.getLocation();
    }

    public void run() {
        if (this.openEvent.shouldContinue()) {
            this.cancel();
            return;
        }
        if (this.boxEntity == null || this.boxEntity.isDead()) {
            return;
        }
        ++this.animationStep;
        Location location = this.boxEntity.getLocation().clone();
        if (this.animationStep <= 20) {
            location.add(0.0, 0.04, 0.0);
            this.centerLoc.add(0.0, 0.04, 0.0);
            this.boxEntity.teleport(location);
            return;
        }
        if (this.animationStep <= 80) {
            location.add(0.0, 0.025, 0.0);
            this.centerLoc.add(0.0, 0.025, 0.0);
            if (this.circleSize < 1.0 && this.animationStep <= 40) {
                this.circleSize += 0.075;
            }
            if (this.circleSize > 0.0 && this.animationStep > 40) {
                this.circleSize -= 0.025;
            }
            if (this.circleSize < 0.0) {
                this.circleSize = 0.0;
            }
            List<Location> list = LocationUtils.getCircle(this.centerLoc, this.circleSize, 40);
            Location location2 = list.get(this.circleStep).clone();
            location2.setYaw(location.getYaw() + 10.0f);
            this.boxEntity.teleport(location2);
            this.centerLoc.setYaw(location2.getYaw());
            ++this.circleStep;
            if (this.circleStep == list.size()) {
                this.circleStep = 0;
            }
        } else {
            this.centerLoc.setYaw(this.centerLoc.getYaw() + 10.0f);
            this.boxEntity.teleport(this.centerLoc);
        }
    }

    @Override
    public void spawnBoxes() {
        final OpenEventData openEventData = this.openEvent.getOpenData();
        Player player = this.openEvent.getPlayer();
        List<Loot> list = this.openEvent.getLoots();
        final int n = 75;
        int n2 = n / openEventData.boxesToOpen;
        int n3 = 0;
        final HashMap<ArmorStand, Integer> hashMap = new HashMap<ArmorStand, Integer>();
        Location location = this.openEvent.getEventLocation();
        location.subtract(0.0, 2.0, 0.0);
        for (int i = 0; i < openEventData.boxesToOpen; ++i) {
            int n4 = (n3 + i * n2) % n;
            ArmorStand armorStand = (ArmorStand)location.getWorld().spawn(location, ArmorStand.class);
            hashMap.put(armorStand, n4);
            Loot loot = list.get(i);
            this.openEvent.getBoxes().put(armorStand, loot);
            BoxEntity.BEFORE_REVEAL.updateBox(armorStand, openEventData.box, loot);
            BoxEntity.updateEntity(armorStand);
        }
        new BukkitRunnable(){
            float circleSize = 0.0f;
            boolean revealStarted = false;

            public void run() {
                if (StandardAnimation.this.openEvent.shouldContinue()) {
                    this.cancel();
                    return;
                }
                for (ArmorStand object : StandardAnimation.this.openEvent.getBoxes().keySet()) {
                    if (!hashMap.containsKey(object)) continue;
                    Location location = object.getLocation();
                    location.setYaw(location.getYaw() + 10.0f);
                    object.teleport(location);
                }
                this.circleSize += 0.1f;
                if (this.circleSize >= 3.0f) {
                    if (!this.revealStarted) {
                        StandardAnimation.this.openEvent.setStartReveal(true);
                        this.revealStarted = true;
                        StandardAnimation.this.idleParticles = true;
                    }
                    return;
                }
                List<Location> list = LocationUtils.getCircle(StandardAnimation.this.openEvent.getEventLocation(), this.circleSize, n);
                for (ArmorStand armorStand : StandardAnimation.this.openEvent.getBoxes().keySet()) {
                    if (!hashMap.containsKey(armorStand)) continue;
                    int n2 = (Integer)hashMap.get(armorStand);
                    if (++n2 == list.size()) {
                        n2 = 0;
                    }
                    hashMap.put(armorStand, n2);
                    Location location = (Location)list.get(n2);
                    location.setY(armorStand.getLocation().getY());
                    location.setYaw(armorStand.getLocation().getYaw());
                    armorStand.teleport(location);
                    Location location2 = BoxEntity.getFixedEyeLoc(armorStand);
                    for (String string : openEventData.box.getAnimationSettings().spiralParticles) {
                        WorldUtils.spawnParticle(location2, string);
                    }
                }
            }
        }.runTaskTimer((Plugin)Main.getPlugin(), 0L, 1L);
    }

    @Override
    public boolean isIdleParticles() {
        return this.idleParticles;
    }
}

