/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.core.events.opening.utils;

import com.xericker.mysteryboxes.Main;
import com.xericker.mysteryboxes.handlers.data.boxes.Box;
import com.xericker.mysteryboxes.handlers.data.loots.Loot;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.ArmorStand;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.MetadataValue;
import utils.ItemUtils;
import utils.PlayerUtils;
import utils.PluginUtils;

public enum BoxEntity {
    BEFORE_REVEAL,
    AFTER_REVEAL;


    public void updateBox(ArmorStand armorStand, Box box, Loot loot) {
        ItemMeta itemMeta;
        boolean bl;
        if (armorStand == null || box == null || loot == null) {
            if (armorStand != null) {
                armorStand.getEquipment().setHelmet(null);
            }
            return;
        }
        Loot.AppearanceSettings appearanceSettings = loot.getAppearanceSettings();
        Material material = this == BEFORE_REVEAL ? box.getBoxSettings().type : appearanceSettings.type;
        ItemStack itemStack = ItemUtils.getItem(material, 1, true, null, null);
        boolean bl2 = bl = !PluginUtils.isEmpty(this == BEFORE_REVEAL ? box.getBoxSettings().head : appearanceSettings.head);
        if (bl) {
            itemStack = PlayerUtils.parseHead(this == BEFORE_REVEAL ? box.getBoxSettings().head : appearanceSettings.head);
        }
        if ((itemMeta = itemStack.getItemMeta()) != null) {
            itemMeta.setCustomModelData(Integer.valueOf(this == BEFORE_REVEAL ? box.getBoxSettings().model : appearanceSettings.model));
            itemStack.setItemMeta(itemMeta);
        }
        armorStand.getEquipment().setHelmet(itemStack);
    }

    public static void updateEntity(ArmorStand armorStand) {
        BoxEntity.updateEntity(armorStand, null);
    }

    public static void updateEntity(ArmorStand armorStand, String string) {
        armorStand.setMetadata(Main.getMetadataValue(), (MetadataValue)Main.getFixedMetadataValue());
        armorStand.setSilent(true);
        armorStand.setInvulnerable(true);
        armorStand.setVisible(false);
        armorStand.setCollidable(false);
        armorStand.setGravity(false);
        armorStand.setMarker(false);
        armorStand.setRemoveWhenFarAway(false);
        if (string != null) {
            armorStand.setCustomName(string);
            armorStand.setCustomNameVisible(true);
        }
    }

    public static Location getFixedEyeLoc(ArmorStand armorStand) {
        return armorStand.getEyeLocation().subtract(0.0, 0.075, 0.0);
    }
}

