/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.core.vaults.editor;

import com.xericker.mysteryboxes.Main;
import com.xericker.mysteryboxes.core.vaults.VaultAction;
import com.xericker.mysteryboxes.core.vaults.VaultData;
import com.xericker.mysteryboxes.menus.Menu;
import com.xericker.mysteryboxes.playerdata.player.PlayerData;
import com.xericker.mysteryboxes.playerdata.player.PlayerDataManager;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import utils.MessageUtils;
import utils.WorldUtils;

public class EditorTask
extends BukkitRunnable {
    public EditorTask() {
        this.runTaskTimer((Plugin)Main.getPlugin(), 0L, 10L);
    }

    public void run() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            Block block;
            PlayerData playerData = PlayerDataManager.getData(player);
            if (playerData.getVaultAction() != VaultAction.VAULT_EDITOR) continue;
            if (player.isSneaking()) {
                Menu.VAULT_MANAGER.open(player);
                player.setSneaking(false);
            }
            if ((block = player.getTargetBlockExact(5)) == null || block.isLiquid()) {
                MessageUtils.sendBar(player, Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 0.1f, 2.0f, "\u00a7eTarget a block! \u00a78- \u00a76\u00a7nShift\u00a7e for \u00a7bVault Manager");
                continue;
            }
            if (VaultData.getVault(block.getLocation()) != null) {
                MessageUtils.sendBar(player, Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 0.1f, 2.0f, "\u00a7aMystery Vault found! \u00a78- \u00a76\u00a7nLeft-click\u00a7e to remove");
                continue;
            }
            WorldUtils.playStepSound(player, block.getLocation(), block.getType(), 1);
            MessageUtils.sendBar(player, Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 0.1f, 2.0f, "\u00a7aPerfect spot! \u00a78- \u00a76\u00a7nRight Click\u00a7e to create");
        }
    }
}

