/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.handlers.data.songs;

import com.xericker.mysteryboxes.Main;
import com.xericker.mysteryboxes.config.files.ConfigValue;
import com.xericker.mysteryboxes.config.handlers.ConfigParser;
import com.xericker.mysteryboxes.handlers.data.songs.DefaultSong;
import com.xericker.mysteryboxes.handlers.data.songs.SongData;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import libraries.ConfigAPI;
import org.bukkit.configuration.file.FileConfiguration;

public class SongManager {
    private static final List<SongData> DATA_LIST = new ArrayList<SongData>();

    public static List<SongData> getList() {
        return DATA_LIST;
    }

    public static SongData getData(String string) {
        return SongManager.getList().stream().filter(songData -> songData.getSongId().equalsIgnoreCase(string)).findFirst().orElse(null);
    }

    public static void registerData() {
        try {
            Object[] objectArray;
            File file;
            DATA_LIST.clear();
            File file2 = Main.getPlugin().getDataFolder();
            File file3 = new File(file2, "config/songs");
            if (!file3.exists()) {
                file3.mkdirs();
            }
            if (!(file = new File(file2, "songpack/songs")).exists()) {
                file.mkdirs();
            }
            if (ConfigParser.getBoolean(ConfigValue.GENERATE_DEFAULT_SONGS).booleanValue()) {
                objectArray = DefaultSong.values();
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    DefaultSong defaultSong = objectArray[i];
                    String object = defaultSong.name().toLowerCase().replace("_", "-");
                    ConfigAPI.registerConfig("song_" + object, "song-", object + ".yml", file3.getPath(), true, Main.getPlugin());
                }
            }
            if ((objectArray = file3.listFiles()) == null) {
                Main.getPlugin().getLogger().warning("The song files array is null.");
                return;
            }
            for (DefaultSong defaultSong : objectArray) {
                FileConfiguration fileConfiguration;
                String string = ((File)((Object)defaultSong)).getName();
                string = string.replace(".yml", "");
                string = string.replace(" ", "");
                string = string.trim();
                String string2 = "song_" + string;
                if (string.isEmpty()) {
                    Main.getPlugin().getLogger().warning("Failed to register song " + string + " (The ID is empty).");
                    continue;
                }
                if (SongManager.getData(string) != null) {
                    Main.getPlugin().getLogger().warning("Failed to register song " + string + " (Already registered).");
                    continue;
                }
                ConfigAPI.registerConfig(string2, ((File)((Object)defaultSong)).getName(), file3.getPath(), false, Main.getPlugin());
                ConfigAPI.Config config = ConfigAPI.getConfig(string2);
                FileConfiguration fileConfiguration2 = fileConfiguration = config != null ? config.getFileConfig() : null;
                if (config == null) {
                    Main.getPlugin().getLogger().warning("Failed to register song " + string + " (The config is null).");
                    continue;
                }
                SongData songData = new SongData(string, fileConfiguration);
                DATA_LIST.add(songData);
            }
        }
        catch (Exception exception) {
            Main.getPlugin().getLogger().warning("Failed to register songs.");
            exception.printStackTrace();
        }
    }
}

