/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.menus.menus.sendgifts;

import com.xericker.mysteryboxes.config.files.LanguageValue;
import com.xericker.mysteryboxes.config.handlers.ConfigParser;
import com.xericker.mysteryboxes.core.filters.BoxFilter;
import com.xericker.mysteryboxes.core.settings.GiftingData;
import com.xericker.mysteryboxes.handlers.data.boxes.Box;
import com.xericker.mysteryboxes.handlers.data.boxes.BoxManager;
import com.xericker.mysteryboxes.menus.Menu;
import com.xericker.mysteryboxes.menus.MenuBuilder;
import com.xericker.mysteryboxes.menus.MenuTrigger;
import com.xericker.mysteryboxes.playerdata.menus.MenuData;
import com.xericker.mysteryboxes.playerdata.menus.MenuDataManager;
import com.xericker.mysteryboxes.playerdata.player.PlayerData;
import com.xericker.mysteryboxes.playerdata.player.PlayerDataManager;
import java.util.Objects;
import java.util.UUID;
import misc.ItemNBT;
import misc.MenuSound;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class MenuEventSendGifts
implements Listener {
    @EventHandler
    public void onInventoryClick(InventoryClickEvent inventoryClickEvent) {
        Object object;
        Object object2;
        Player player = (Player)inventoryClickEvent.getWhoClicked();
        MenuData menuData = MenuDataManager.getData(player);
        if (menuData.getCurrentType() == null) {
            return;
        }
        PlayerData playerData = PlayerDataManager.getData(player);
        MenuBuilder menuBuilder = menuData.getMenu();
        if (!menuData.getCurrentType().validateClick(player, Menu.SEND_GIFTS, inventoryClickEvent)) {
            return;
        }
        ItemStack itemStack = inventoryClickEvent.getCurrentItem();
        GiftingData giftingData = playerData.getGiftingData();
        if (ItemNBT.contains(itemStack, "itemTrigger")) {
            object2 = ItemNBT.getString(itemStack, "itemTrigger");
            if (Objects.equals(object2, MenuTrigger.PREVIOUS_PAGE.name())) {
                menuBuilder.setPage(menuBuilder.getPage() - 1);
                menuBuilder.update();
                MenuSound.SUCCESS.play(player);
            }
            if (Objects.equals(object2, MenuTrigger.NEXT_PAGE.name())) {
                menuBuilder.setPage(menuBuilder.getPage() + 1);
                menuBuilder.update();
                MenuSound.SUCCESS.play(player);
            }
            object = null;
            if (Objects.equals(object2, MenuTrigger.MERGE_BOXES_ENABLED.name())) {
                object = BoxFilter.SHOW_ALL;
            } else if (Objects.equals(object2, MenuTrigger.MERGE_BOXES_DISABLED.name())) {
                object = BoxFilter.MERGE_BOXES;
            }
            if (object != null) {
                playerData.setBoxFilter((BoxFilter)((Object)object));
                menuBuilder.update();
                MenuSound.SUCCESS.play(player);
            }
        }
        if (giftingData.getGiftingState() == GiftingData.GiftingState.CHOOSE_GIFT && ItemNBT.contains(itemStack, "boxId")) {
            object2 = BoxManager.getBox(ItemNBT.getString(itemStack, "boxId"));
            giftingData.setChosenGift((Box)object2);
            giftingData.setGiftingState(GiftingData.GiftingState.CHOOSE_RECEIVER);
            menuBuilder.update();
            MenuSound.SUCCESS.play(player);
        }
        if (giftingData.getGiftingState() != GiftingData.GiftingState.CHOOSE_RECEIVER) {
            return;
        }
        if (!ItemNBT.contains(itemStack, "receiverId")) {
            return;
        }
        object2 = UUID.fromString(ItemNBT.getString(itemStack, "receiverId"));
        object = Bukkit.getPlayer((UUID)object2);
        if (object == null) {
            for (String string : ConfigParser.getStringList(LanguageValue.GENERAL_PLAYER_NOT_FOUND)) {
                player.sendMessage(string);
            }
            player.closeInventory();
            MenuSound.ERROR.play(player);
            return;
        }
        Box box = giftingData.getChosenGift();
        player.closeInventory();
        box.giftBox(player, (Player)object);
    }
}

