/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.scanners;

import org.reflections.Store;
import org.reflections.scanners.AbstractScanner;
import org.reflections.util.Utils;

public class TypeElementsScanner
extends AbstractScanner {
    private boolean includeFields = true;
    private boolean includeMethods = true;
    private boolean includeAnnotations = true;
    private boolean publicOnly = true;

    @Override
    public void scan(Object object, Store store) {
        String string;
        String string2 = this.getMetadataAdapter().getClassName(object);
        if (!this.acceptResult(string2)) {
            return;
        }
        this.put(store, string2, "");
        if (this.includeFields) {
            for (Object object2 : this.getMetadataAdapter().getFields(object)) {
                string = this.getMetadataAdapter().getFieldName(object2);
                this.put(store, string2, string);
            }
        }
        if (this.includeMethods) {
            for (Object object2 : this.getMetadataAdapter().getMethods(object)) {
                if (this.publicOnly && !this.getMetadataAdapter().isPublic(object2)) continue;
                string = this.getMetadataAdapter().getMethodName(object2) + "(" + Utils.join(this.getMetadataAdapter().getParameterNames(object2), ", ") + ")";
                this.put(store, string2, string);
            }
        }
        if (this.includeAnnotations) {
            for (Object object3 : this.getMetadataAdapter().getClassAnnotationNames(object)) {
                this.put(store, string2, "@" + object3);
            }
        }
    }

    public TypeElementsScanner includeFields() {
        return this.includeFields(true);
    }

    public TypeElementsScanner includeFields(boolean bl) {
        this.includeFields = bl;
        return this;
    }

    public TypeElementsScanner includeMethods() {
        return this.includeMethods(true);
    }

    public TypeElementsScanner includeMethods(boolean bl) {
        this.includeMethods = bl;
        return this;
    }

    public TypeElementsScanner includeAnnotations() {
        return this.includeAnnotations(true);
    }

    public TypeElementsScanner includeAnnotations(boolean bl) {
        this.includeAnnotations = bl;
        return this;
    }

    public TypeElementsScanner publicOnly(boolean bl) {
        this.publicOnly = bl;
        return this;
    }

    public TypeElementsScanner publicOnly() {
        return this.publicOnly(true);
    }
}

