/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.data;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import net.momirealms.customnameplates.CustomNameplates;
import net.momirealms.customnameplates.data.DataStorageInterface;
import net.momirealms.customnameplates.data.PlayerData;
import net.momirealms.customnameplates.data.StorageType;
import net.momirealms.customnameplates.manager.ConfigManager;
import net.momirealms.customnameplates.utils.ConfigUtils;
import org.bukkit.configuration.file.YamlConfiguration;

public class FileStorageImpl
implements DataStorageInterface {
    private final CustomNameplates plugin;

    public FileStorageImpl(CustomNameplates plugin) {
        this.plugin = plugin;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void disable() {
    }

    @Override
    public PlayerData loadData(UUID uuid) {
        YamlConfiguration data = ConfigUtils.readData(new File(this.plugin.getDataFolder(), "player_data" + File.separator + uuid + ".yml"));
        String bubbles = data.getString("bubbles", ConfigManager.enableBubbles ? this.plugin.getChatBubblesManager().getDefaultBubble() : "none");
        String nameplate = data.getString("nameplate", ConfigManager.enableNameplates ? this.plugin.getNameplateManager().getDefault_nameplate() : "none");
        PlayerData playerData = new PlayerData(uuid, nameplate, bubbles);
        this.saveData(playerData);
        return playerData;
    }

    @Override
    public void saveData(PlayerData playerData) {
        YamlConfiguration data = new YamlConfiguration();
        data.set("bubbles", (Object)playerData.getBubble());
        data.set("nameplate", (Object)playerData.getNameplate());
        try {
            data.save(new File(this.plugin.getDataFolder(), "player_data" + File.separator + playerData.getUuid() + ".yml"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public StorageType getStorageType() {
        return StorageType.YAML;
    }
}

