/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.data;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import net.momirealms.customnameplates.CustomNameplates;
import net.momirealms.customnameplates.data.DataStorageInterface;
import net.momirealms.customnameplates.data.PlayerData;
import net.momirealms.customnameplates.data.SqlConnection;
import net.momirealms.customnameplates.data.StorageType;
import net.momirealms.customnameplates.manager.ConfigManager;
import net.momirealms.customnameplates.utils.AdventureUtils;

public class MySQLStorageImpl
implements DataStorageInterface {
    private final SqlConnection sqlConnection;
    private final CustomNameplates plugin;

    public MySQLStorageImpl(CustomNameplates plugin) {
        this.plugin = plugin;
        this.sqlConnection = new SqlConnection(this);
    }

    @Override
    public void initialize() {
        this.sqlConnection.createNewHikariConfiguration();
        this.createTableIfNotExist(this.sqlConnection.getTable());
    }

    @Override
    public void disable() {
        this.sqlConnection.close();
    }

    @Override
    public PlayerData loadData(UUID uuid) {
        PlayerData playerData = null;
        String sql = String.format("SELECT * FROM `%s` WHERE `uuid` = ?", this.sqlConnection.getTable());
        try (Connection connection = this.sqlConnection.getConnectionAndCheck();
             PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setString(1, uuid.toString());
            ResultSet rs = statement.executeQuery();
            if (rs.next()) {
                String nameplate = rs.getString(2);
                String bubbles = rs.getString(3);
                playerData = new PlayerData(uuid, nameplate, bubbles);
            } else {
                playerData = new PlayerData(uuid, ConfigManager.enableNameplates ? this.plugin.getNameplateManager().getDefault_nameplate() : "none", ConfigManager.enableBubbles ? this.plugin.getChatBubblesManager().getDefaultBubble() : "none");
                this.insertData(uuid, playerData.getNameplate(), playerData.getBubble());
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return playerData;
    }

    @Override
    public void saveData(PlayerData playerData) {
        String sql = String.format("UPDATE `%s` SET `equipped` = ?, `bubble` = ? WHERE `uuid` = ?", this.sqlConnection.getTable());
        try (Connection connection = this.sqlConnection.getConnectionAndCheck();
             PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setString(1, playerData.getNameplate());
            statement.setString(2, playerData.getBubble());
            statement.setString(3, playerData.getUuid().toString());
            statement.executeUpdate();
        }
        catch (SQLException ex) {
            AdventureUtils.consoleMessage("[CustomNameplates] Failed to update data for " + playerData.getUuid());
        }
    }

    @Override
    public StorageType getStorageType() {
        return StorageType.SQL;
    }

    private void createTableIfNotExist(String table) {
        String sql = String.format("CREATE TABLE IF NOT EXISTS `%s` ( `uuid` VARCHAR(36) NOT NULL , `equipped` VARCHAR(32) NOT NULL , `bubble` VARCHAR(32) NOT NULL , PRIMARY KEY (`uuid`) )", table);
        try (Connection connection = this.sqlConnection.getConnectionAndCheck();
             PreparedStatement statement = connection.prepareStatement(sql);){
            statement.executeUpdate();
        }
        catch (SQLException ex) {
            AdventureUtils.consoleMessage("[CustomNameplates] Failed to create table");
        }
    }

    private void insertData(UUID uuid, String nameplate, String bubbles) {
        String sql = String.format("INSERT INTO `%s`(`uuid`, `equipped`, `bubble`) VALUES (?, ?, ?)", this.sqlConnection.getTable());
        try (Connection connection = this.sqlConnection.getConnectionAndCheck();
             PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setString(1, uuid.toString());
            statement.setString(2, nameplate);
            statement.setString(3, bubbles);
            statement.executeUpdate();
        }
        catch (SQLException ex) {
            AdventureUtils.consoleMessage("[CustomNameplates] Failed to insert data for " + uuid);
        }
    }
}

