/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.manager;

import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.momirealms.customnameplates.CustomNameplates;
import net.momirealms.customnameplates.libs.net.kyori.adventure.text.ScoreComponent;
import net.momirealms.customnameplates.libs.net.kyori.adventure.text.TranslatableComponent;
import net.momirealms.customnameplates.libs.net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.momirealms.customnameplates.listener.JoinQuitListener;
import net.momirealms.customnameplates.listener.packet.ActionBarListener;
import net.momirealms.customnameplates.listener.packet.ChatMessageListener;
import net.momirealms.customnameplates.listener.packet.SystemChatListener;
import net.momirealms.customnameplates.manager.ConfigManager;
import net.momirealms.customnameplates.object.Function;
import net.momirealms.customnameplates.object.actionbar.ActionBarConfig;
import net.momirealms.customnameplates.object.actionbar.ActionBarTask;
import net.momirealms.customnameplates.utils.AdventureUtils;
import net.momirealms.customnameplates.utils.ConfigUtils;
import net.momirealms.customnameplates.utils.GeyserUtils;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class ActionBarManager
extends Function {
    private final LinkedHashMap<String, ActionBarConfig> actionBarConfigMap;
    private final ConcurrentHashMap<UUID, ActionBarTask> actionBarTaskMap;
    private final ActionBarListener actionBarListener;
    private SystemChatListener systemChatListener;
    private ChatMessageListener chatMessageListener;
    private final JoinQuitListener joinQuitListener;
    private final CustomNameplates plugin;

    public ActionBarManager(CustomNameplates plugin) {
        this.plugin = plugin;
        this.actionBarConfigMap = new LinkedHashMap();
        this.actionBarTaskMap = new ConcurrentHashMap();
        this.joinQuitListener = new JoinQuitListener(this);
        this.actionBarListener = new ActionBarListener(this);
        if (plugin.getVersionHelper().isVersionNewerThan1_19()) {
            this.systemChatListener = new SystemChatListener(this);
        } else {
            this.chatMessageListener = new ChatMessageListener(this);
        }
    }

    @Override
    public void load() {
        if (!ConfigManager.enableActionBar) {
            return;
        }
        this.loadConfig();
        Bukkit.getPluginManager().registerEvents((Listener)this.joinQuitListener, (Plugin)this.plugin);
        if (this.actionBarListener != null) {
            CustomNameplates.getProtocolManager().addPacketListener((PacketListener)this.actionBarListener);
        }
        if (this.systemChatListener != null) {
            CustomNameplates.getProtocolManager().addPacketListener((PacketListener)this.systemChatListener);
        }
        if (this.chatMessageListener != null) {
            CustomNameplates.getProtocolManager().addPacketListener((PacketListener)this.chatMessageListener);
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.onJoin(player);
        }
    }

    @Override
    public void unload() {
        for (ActionBarTask actionBarTask : this.actionBarTaskMap.values()) {
            actionBarTask.stop();
        }
        this.actionBarConfigMap.clear();
        if (this.actionBarListener != null) {
            CustomNameplates.getProtocolManager().removePacketListener((PacketListener)this.actionBarListener);
        }
        if (this.systemChatListener != null) {
            CustomNameplates.getProtocolManager().removePacketListener((PacketListener)this.systemChatListener);
        }
        if (this.chatMessageListener != null) {
            CustomNameplates.getProtocolManager().removePacketListener((PacketListener)this.chatMessageListener);
        }
        HandlerList.unregisterAll((Listener)this.joinQuitListener);
    }

    @Override
    public void onJoin(Player player) {
        if (ConfigManager.disableForBedrock && this.plugin.getVersionHelper().isGeyser() && GeyserUtils.isBedrockPlayer(player.getUniqueId())) {
            return;
        }
        ActionBarTask actionBarTask = new ActionBarTask(player, this.actionBarConfigMap.values().toArray(new ActionBarConfig[0]));
        this.actionBarTaskMap.put(player.getUniqueId(), actionBarTask);
        actionBarTask.start();
    }

    @Override
    public void onQuit(Player player) {
        ActionBarTask actionBarTask = this.actionBarTaskMap.remove(player.getUniqueId());
        if (actionBarTask != null) {
            actionBarTask.stop();
        }
    }

    @Nullable
    public ActionBarTask getActionBarTask(UUID uuid) {
        return this.actionBarTaskMap.get(uuid);
    }

    private void loadConfig() {
        YamlConfiguration config = ConfigUtils.getConfig("configs" + File.separator + "actionbar.yml");
        for (String key : config.getKeys(false)) {
            String[] stringArray;
            ConfigurationSection actionBarSection = config.getConfigurationSection(key);
            if (actionBarSection == null) continue;
            int n = actionBarSection.getInt("switch-interval", 15) * 20;
            if (actionBarSection.getString("text") == null) {
                stringArray = actionBarSection.getStringList("dynamic-text").toArray(new String[0]);
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = actionBarSection.getString("text");
            }
            this.actionBarConfigMap.put(key, new ActionBarConfig(n, stringArray, ConfigUtils.getRequirements(actionBarSection.getConfigurationSection("conditions"))));
        }
        AdventureUtils.consoleMessage("[CustomNameplates] Loaded <green>" + this.actionBarConfigMap.size() + " <gray>actionbars");
    }

    public void onReceiveActionBarPacket(PacketEvent event) {
        ActionBarTask actionBarTask;
        PacketContainer packet = event.getPacket();
        WrappedChatComponent wrappedChatComponent = (WrappedChatComponent)packet.getChatComponents().read(0);
        if (wrappedChatComponent != null && (actionBarTask = this.getActionBarTask(event.getPlayer().getUniqueId())) != null) {
            ScoreComponent scoreComponent;
            String strJson = wrappedChatComponent.getJson();
            if (strJson.endsWith("\"objective\":\"actionbar\"}}")) {
                return;
            }
            Object component = GsonComponentSerializer.gson().deserialize(strJson);
            if (component instanceof ScoreComponent && (scoreComponent = (ScoreComponent)component).name().equals("nameplates") && scoreComponent.objective().equals("actionbar")) {
                return;
            }
            event.setCancelled(true);
            actionBarTask.setOtherText(AdventureUtils.getMiniMessageFormat(component), System.currentTimeMillis());
        }
    }

    public void onReceiveSystemChatPacket(PacketEvent event) {
        ActionBarTask actionBarTask;
        PacketContainer packet = event.getPacket();
        Boolean overlay = (Boolean)packet.getBooleans().readSafely(0);
        if (overlay != null && overlay.booleanValue() && (actionBarTask = this.getActionBarTask(event.getPlayer().getUniqueId())) != null) {
            event.setCancelled(true);
            String json = (String)packet.getStrings().readSafely(0);
            if (json != null && !json.equals("")) {
                Object component = GsonComponentSerializer.gson().deserialize(json);
                if (component instanceof TranslatableComponent) {
                    return;
                }
                actionBarTask.setOtherText(AdventureUtils.getMiniMessageFormat(component), System.currentTimeMillis());
            }
        }
    }

    public void onReceiveChatMessagePacket(PacketEvent event) {
        ActionBarTask actionBarTask;
        PacketContainer packet = event.getPacket();
        EnumWrappers.ChatType type = (EnumWrappers.ChatType)packet.getChatTypes().readSafely(0);
        if (type == EnumWrappers.ChatType.GAME_INFO && (actionBarTask = this.getActionBarTask(event.getPlayer().getUniqueId())) != null) {
            event.setCancelled(true);
            WrappedChatComponent wrappedChatComponent = (WrappedChatComponent)packet.getChatComponents().read(0);
            if (wrappedChatComponent != null) {
                String json = wrappedChatComponent.getJson();
                Object component = GsonComponentSerializer.gson().deserialize(json);
                if (component instanceof TranslatableComponent) {
                    return;
                }
                actionBarTask.setOtherText(AdventureUtils.getMiniMessageFormat(component), System.currentTimeMillis());
            }
        }
    }

    public String getOtherPluginActionBarText(Player player) {
        ActionBarTask actionBarTask = this.getActionBarTask(player.getUniqueId());
        if (actionBarTask != null) {
            return actionBarTask.getOtherText();
        }
        return "";
    }
}

