/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.object.nameplate;

import me.clip.placeholderapi.PlaceholderAPI;
import net.momirealms.customnameplates.CustomNameplates;
import net.momirealms.customnameplates.libs.net.kyori.adventure.text.Component;
import net.momirealms.customnameplates.manager.NameplateManager;
import net.momirealms.customnameplates.object.DynamicText;
import net.momirealms.customnameplates.object.nameplate.NameplateConfig;
import net.momirealms.customnameplates.utils.AdventureUtils;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class NameplatesTeam {
    private final NameplateManager nameplateManager;
    private final Player player;
    private ChatColor color;
    private final DynamicText prefix;
    private final DynamicText suffix;
    private String nameplate_prefix;
    private String nameplate_suffix;
    private String nameplate;
    private final String team_name;

    public NameplatesTeam(NameplateManager nameplateManager, Player player, String team_name) {
        this.nameplateManager = nameplateManager;
        this.team_name = team_name;
        this.player = player;
        this.prefix = new DynamicText(player, nameplateManager.getPrefix());
        this.suffix = new DynamicText(player, nameplateManager.getSuffix());
        this.update(true);
    }

    public boolean update(boolean force) {
        boolean updated;
        String newNameplate = this.nameplateManager.getEquippedNameplate(this.player);
        NameplateConfig nameplateConfig = this.nameplateManager.getNameplateConfig(newNameplate);
        boolean bl = updated = this.prefix.update() || this.suffix.update() || force || !newNameplate.equals(this.nameplate);
        if (newNameplate.equals("none") || nameplateConfig == null) {
            this.color = ChatColor.WHITE;
            this.nameplate = "none";
            if (updated) {
                this.nameplate = newNameplate;
                this.nameplate_prefix = this.prefix.getLatestValue();
                this.nameplate_suffix = this.suffix.getLatestValue();
            }
        } else {
            this.color = nameplateConfig.color();
            String name = PlaceholderAPI.setPlaceholders((Player)this.player, (String)this.nameplateManager.getPlayerNamePapi());
            if (updated) {
                this.nameplate = newNameplate;
                String text = (this.nameplateManager.isPrefixHidden() ? "" : AdventureUtils.stripAllTags(this.prefix.getLatestValue())) + name + (this.nameplateManager.isSuffixHidden() ? "" : AdventureUtils.stripAllTags(this.suffix.getLatestValue()));
                this.nameplate_prefix = this.nameplateManager.getNameplatePrefixWithFont(text, nameplateConfig) + (this.nameplateManager.isPrefixHidden() ? "" : this.prefix.getLatestValue());
                this.nameplate_suffix = CustomNameplates.getInstance().getFontManager().getSuffixStringWithFont(text) + (this.nameplateManager.isPrefixHidden() ? "" : this.suffix.getLatestValue());
            }
        }
        return updated;
    }

    public String getTeam_name() {
        return this.team_name;
    }

    public ChatColor getColor() {
        return this.color;
    }

    public String getNameplatePrefixText() {
        return this.nameplate_prefix;
    }

    public String getNameplateSuffixText() {
        return this.nameplate_suffix;
    }

    public Component getNameplatePrefixComponent() {
        return AdventureUtils.getComponentFromMiniMessage(this.nameplate_prefix);
    }

    public Component getNameplateSuffixComponent() {
        return AdventureUtils.getComponentFromMiniMessage(this.nameplate_suffix);
    }
}

