/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.happyhud;

import com.ehhthan.happyhud.api.HudHolder;
import com.ehhthan.happyhud.api.command.HappyHUDCommand;
import com.ehhthan.happyhud.api.element.layout.HudLayout;
import com.ehhthan.happyhud.api.element.popup.HudPopup;
import com.ehhthan.happyhud.api.event.listener.HudEventListener;
import com.ehhthan.happyhud.api.resourcepack.builder.BuildablePack;
import com.ehhthan.happyhud.api.util.NegativeSpace;
import com.ehhthan.happyhud.api.util.ServerVersion;
import com.ehhthan.happyhud.comp.geyser.FloodgateSupport;
import com.ehhthan.happyhud.comp.geyser.GeyserHandler;
import com.ehhthan.happyhud.comp.geyser.GeyserSpigotSupport;
import com.ehhthan.happyhud.comp.protocollib.ProtocolLibSupport;
import com.ehhthan.happyhud.file.DirectoryCopyFileVisitor;
import com.ehhthan.happyhud.manager.AssetManager;
import com.ehhthan.happyhud.manager.ComponentManager;
import com.ehhthan.happyhud.manager.ConditionManager;
import com.ehhthan.happyhud.manager.FontManager;
import com.ehhthan.happyhud.manager.LanguageManager;
import com.ehhthan.happyhud.manager.LayoutManager;
import com.ehhthan.happyhud.manager.ListenerManager;
import com.ehhthan.happyhud.manager.ParserManager;
import com.ehhthan.happyhud.manager.PopupManager;
import com.ehhthan.libraries.acf.InvalidCommandArgument;
import com.ehhthan.libraries.acf.PaperCommandManager;
import com.ehhthan.libraries.bstats.bukkit.Metrics;
import com.ehhthan.libraries.kyori.adventure.platform.bukkit.BukkitAudiences;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class HappyHUD
extends JavaPlugin {
    private static HappyHUD INSTANCE;
    private BukkitAudiences adventure;
    private final AssetManager assetManager = new AssetManager();
    private final PopupManager popupManager = new PopupManager();
    private final LayoutManager layoutManager = new LayoutManager();
    private final ListenerManager listenerManager = new ListenerManager();
    private final FontManager fontManager = new FontManager();
    private final ConditionManager conditionManager = new ConditionManager();
    private ComponentManager components;
    private ParserManager parserManager;
    private LanguageManager languageManager;
    private ServerVersion version;
    private ProtocolLibSupport protocol;
    private GeyserHandler<?> geyser;

    public void onEnable() {
        HappyHUD.loadConfig0();
        INSTANCE = this;
        this.saveDefaultConfig();
        if (this.getConfig().getBoolean("generate-default-files", true)) {
            try {
                DirectoryCopyFileVisitor.INSTANCE.copy("default", this.getDataFolder().toPath());
            }
            catch (IOException | URISyntaxException exception) {
                this.getLogger().log(Level.SEVERE, "Could not generate default files.");
                exception.printStackTrace();
            }
        } else {
            this.getLogger().log(Level.INFO, "Ignoring default file generation...");
        }
        if (this.getConfig().getBoolean("generate-unicode-files", true)) {
            try {
                DirectoryCopyFileVisitor.INSTANCE.copy("unicode", this.getDataFolder().toPath());
            }
            catch (IOException | URISyntaxException exception) {
                this.getLogger().log(Level.SEVERE, "Could not generate unicode files.");
                exception.printStackTrace();
            }
        } else {
            this.getLogger().log(Level.INFO, "Ignoring unicode file generation...");
        }
        new Metrics(this, 16153);
        this.adventure = BukkitAudiences.create((Plugin)this);
        this.version = new ServerVersion(Bukkit.getServer().getClass());
        if (Bukkit.getPluginManager().getPlugin("ProtocolLib") != null) {
            this.protocol = new ProtocolLibSupport(this);
            this.getLogger().log(Level.INFO, "ProtocolLib support detected.");
        }
        if (Bukkit.getPluginManager().getPlugin("floodgate") != null) {
            this.geyser = new FloodgateSupport();
            this.getLogger().log(Level.INFO, "Floodgate Geyser support detected.");
        } else if (Bukkit.getPluginManager().getPlugin("Geyser-Spigot") != null) {
            this.geyser = new GeyserSpigotSupport();
            this.getLogger().log(Level.INFO, "Geyser Spigot support detected.");
        }
        this.languageManager = new LanguageManager(this);
        this.parserManager = new ParserManager(this);
        this.reload();
        this.getServer().getPluginManager().registerEvents((Listener)new HudHolder.PlayerListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new HudEventListener(), (Plugin)this);
        this.registerCommands();
    }

    public void reload() {
        this.reloadConfig();
        int n = this.getConfig().contains("config-version", true) ? this.getConfig().getInt("config-version") : -1;
        int n2 = this.getConfig().getDefaults().getInt("config-version", -1);
        if (n != n2) {
            this.getLogger().warning("You may be using an outdated config.yml!");
            this.getLogger().warning("(Your config version: '" + n + "' | Expected config version: '" + n2 + "')");
        }
        this.languageManager.reload(this);
        this.listenerManager.reload(this);
        this.fontManager.reload(this);
        this.assetManager.reload(this);
        this.layoutManager.reload(this);
        this.popupManager.reload(this);
        this.protocol.reload();
        this.components = new ComponentManager(new BuildablePack(this));
        for (HudHolder hudHolder : HudHolder.holders()) {
            hudHolder.reloadLayouts();
        }
    }

    private void registerCommands() {
        PaperCommandManager paperCommandManager = new PaperCommandManager((Plugin)this);
        paperCommandManager.getCommandCompletions().registerCompletion("layouts", bukkitCommandCompletionContext -> this.layoutManager.getLayouts().stream().map(HudLayout::getKey).toList());
        paperCommandManager.getCommandCompletions().registerCompletion("popups", bukkitCommandCompletionContext -> this.popupManager.getPopups().stream().map(HudPopup::getKey).toList());
        paperCommandManager.getCommandCompletions().registerCompletion("holders", bukkitCommandCompletionContext -> {
            List list = HudHolder.holders().stream().map(hudHolder -> hudHolder.player().getName()).collect(Collectors.toList());
            list.add("*");
            return list;
        });
        paperCommandManager.getCommandContexts().registerContext(HudLayout.class, bukkitCommandExecutionContext -> {
            String string = bukkitCommandExecutionContext.getFirstArg();
            if (string == null || !this.layoutManager.has(string)) {
                throw new InvalidCommandArgument("Invalid layout specified.");
            }
            bukkitCommandExecutionContext.popFirstArg();
            return this.layoutManager.get(string);
        });
        paperCommandManager.getCommandContexts().registerContext(HudPopup.class, bukkitCommandExecutionContext -> {
            String string = bukkitCommandExecutionContext.getFirstArg();
            if (string == null || !this.popupManager.has(string)) {
                throw new InvalidCommandArgument("Invalid popup specified.");
            }
            bukkitCommandExecutionContext.popFirstArg();
            return this.popupManager.get(string);
        });
        paperCommandManager.getCommandContexts().registerContext(HudHolder[].class, bukkitCommandExecutionContext -> {
            Player player;
            String string = bukkitCommandExecutionContext.getFirstArg();
            if (string.equalsIgnoreCase("*")) {
                bukkitCommandExecutionContext.popFirstArg();
                return HudHolder.holders().toArray(new HudHolder[0]);
            }
            Player player2 = player = string != null ? Bukkit.getPlayer((String)string) : null;
            if (!HudHolder.has(player)) {
                throw new InvalidCommandArgument("Invalid hud holder specified.");
            }
            bukkitCommandExecutionContext.popFirstArg();
            return new HudHolder[]{HudHolder.get(player)};
        });
        paperCommandManager.getCommandContexts().registerContext(HudHolder.class, bukkitCommandExecutionContext -> {
            Player player;
            String string = bukkitCommandExecutionContext.getFirstArg();
            Player player2 = player = string != null ? Bukkit.getPlayer((String)string) : null;
            if (!HudHolder.has(player)) {
                throw new InvalidCommandArgument("Invalid hud holder specified.");
            }
            bukkitCommandExecutionContext.popFirstArg();
            return HudHolder.get(player);
        });
        paperCommandManager.registerCommand(new HappyHUDCommand(this, this.languageManager));
    }

    public static HappyHUD getInstance() {
        return INSTANCE;
    }

    public void onDisable() {
        if (this.adventure != null) {
            this.adventure.close();
            this.adventure = null;
        }
    }

    @NotNull
    public BukkitAudiences adventure() {
        if (this.adventure == null) {
            throw new IllegalStateException("Tried to access Adventure when the plugin was disabled!");
        }
        return this.adventure;
    }

    public AssetManager assets() {
        return this.assetManager;
    }

    public PopupManager popups() {
        return this.popupManager;
    }

    public ComponentManager components() {
        return this.components;
    }

    public LayoutManager layouts() {
        return this.layoutManager;
    }

    public ListenerManager listeners() {
        return this.listenerManager;
    }

    public ParserManager parsers() {
        return this.parserManager;
    }

    public FontManager fonts() {
        return this.fontManager;
    }

    public ConditionManager conditions() {
        return this.conditionManager;
    }

    public ServerVersion version() {
        return this.version;
    }

    public NegativeSpace spaces() {
        return NegativeSpace.MODERN;
    }

    public ProtocolLibSupport protocol() {
        return this.protocol;
    }

    public GeyserHandler<?> getGeyser() {
        return this.geyser;
    }

    private static /* bridge */ /* synthetic */ void loadConfig0() {
        try {
            URLConnection con = new URL("https://api.spigotmc.org/legacy/premium.php?user_id=%%%%%%&resource_id=%%%%%&nonce=%%%%%%%%%%%").openConnection();
            con.setConnectTimeout(1000);
            con.setReadTimeout(1000);
            ((HttpURLConnection)con).setInstanceFollowRedirects(true);
            String response = new BufferedReader(new InputStreamReader(con.getInputStream())).readLine();
            if ("false".equals(response)) {
                throw new RuntimeException("Access to this plugin has been disabled! Please contact the author!");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

