/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.happyhud.api.command;

import com.ehhthan.happyhud.HappyHUD;
import com.ehhthan.happyhud.api.HudHolder;
import com.ehhthan.happyhud.api.element.layout.HudLayout;
import com.ehhthan.happyhud.api.element.popup.HudPopup;
import com.ehhthan.happyhud.manager.LanguageManager;
import com.ehhthan.libraries.acf.BaseCommand;
import com.ehhthan.libraries.acf.annotation.CommandAlias;
import com.ehhthan.libraries.acf.annotation.CommandCompletion;
import com.ehhthan.libraries.acf.annotation.CommandPermission;
import com.ehhthan.libraries.acf.annotation.Default;
import com.ehhthan.libraries.acf.annotation.Description;
import com.ehhthan.libraries.acf.annotation.Optional;
import com.ehhthan.libraries.acf.annotation.Subcommand;
import com.ehhthan.libraries.acf.annotation.Syntax;
import com.ehhthan.libraries.kyori.adventure.text.Component;
import com.ehhthan.libraries.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import com.ehhthan.libraries.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.CommandSender;

@CommandAlias(value="happyhuds|happyhud|huds|hud|hh")
@Description(value="Main happyhud command.")
public class HappyHUDCommand
extends BaseCommand {
    private final HappyHUD plugin;
    private final LanguageManager language;

    public HappyHUDCommand(HappyHUD happyHUD, LanguageManager languageManager) {
        this.plugin = happyHUD;
        this.language = languageManager;
    }

    @Subcommand(value="reload")
    @CommandPermission(value="happyhud.reload")
    @Description(value="Reload the entire plugin.")
    @CommandCompletion(value="-s")
    @Syntax(value="[-s]")
    public void onReloadCommand(CommandSender commandSender, @Default String string) {
        this.plugin.reload();
        Component component = this.language.getMessage("reload", true);
        if (component != null && HappyHUDCommand.isNotSilent(string)) {
            this.plugin.adventure().sender(commandSender).sendMessage(component);
        }
    }

    @Subcommand(value="layout")
    @CommandPermission(value="happyhud.layout")
    @Description(value="Control a player's layout.")
    @CommandCompletion(value="@holders add|remove|reset @layouts -s")
    @Syntax(value="<player> <add|remove|reset> <layout> [-s]")
    public void onLayoutCommand(CommandSender commandSender, HudHolder hudHolder, String string, HudLayout hudLayout, @Default String string2) {
        String string3;
        if (string.equalsIgnoreCase("add")) {
            string3 = hudHolder.addLayout(hudLayout) ? "layout-add-success" : "layout-add-fail";
        } else if (string.equalsIgnoreCase("remove")) {
            string3 = hudHolder.removeLayout(hudLayout) ? "layout-remove-success" : "layout-remove-fail";
        } else if (string.equalsIgnoreCase("reset")) {
            hudHolder.resetLayout(hudLayout);
            string3 = "layout-reset-success";
        } else {
            string3 = "layout-invalid-option";
        }
        hudHolder.send();
        Component component = this.language.getMessage(string3, true, HappyHUDCommand.getPlaceholders(commandSender, hudHolder, hudLayout));
        if (component != null && HappyHUDCommand.isNotSilent(string2)) {
            this.plugin.adventure().sender(commandSender).sendMessage(component);
        }
    }

    @Subcommand(value="popup")
    @CommandPermission(value="happyhud.popup")
    @Description(value="Send a player a popup.")
    @CommandCompletion(value="@holders @popups 10|20|40|100")
    @Syntax(value="<holder> <popup> <ticks> <args separated by '|'>")
    public void onPopupCommand(CommandSender commandSender, HudHolder[] hudHolderArray, HudPopup hudPopup, int n, @Optional String string) {
        String[] stringArray = string != null ? string.split("\\|") : new String[]{};
        for (HudHolder hudHolder : hudHolderArray) {
            hudHolder.sendPopup(hudPopup, n, stringArray);
        }
    }

    private static boolean isNotSilent(String string) {
        return !string.equalsIgnoreCase("-s");
    }

    private static TagResolver getPlaceholders(CommandSender commandSender, HudHolder hudHolder, HudLayout hudLayout) {
        return TagResolver.builder().resolver(Placeholder.unparsed("sender", commandSender.getName())).resolver(Placeholder.unparsed("holder", hudHolder.player().getName())).resolver(Placeholder.unparsed("layout", hudLayout.getKey())).build();
    }
}

