/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.happyhud.api.event.listener;

import com.ehhthan.happyhud.HappyHUD;
import com.ehhthan.happyhud.api.HudHolder;
import com.ehhthan.happyhud.api.event.PlayerUpdateAttributeEvent;
import com.ehhthan.happyhud.api.event.PlayerUpdateConsumableEvent;
import com.ehhthan.happyhud.api.event.PlayerUpdateExperienceEvent;
import com.ehhthan.happyhud.api.hud.layer.listener.LayerListener;
import com.ehhthan.happyhud.api.hud.layer.listener.ProvidedListener;
import org.bukkit.Bukkit;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityAirChangeEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.plugin.Plugin;

public class HudEventListener
implements Listener {
    @EventHandler
    public void updateConsumable(PlayerUpdateConsumableEvent playerUpdateConsumableEvent) {
        this.update(playerUpdateConsumableEvent.getPlayer(), ProvidedListener.HEALTH, ProvidedListener.FOOD);
    }

    @EventHandler
    public void updateArmor(PlayerUpdateAttributeEvent playerUpdateAttributeEvent) {
        if (playerUpdateAttributeEvent.getAttribute() == Attribute.GENERIC_ARMOR) {
            this.update(playerUpdateAttributeEvent.getPlayer(), ProvidedListener.ARMOR);
        }
    }

    @EventHandler
    public void airChange(EntityAirChangeEvent entityAirChangeEvent) {
        Entity entity = entityAirChangeEvent.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.update(player, ProvidedListener.AIR);
        }
    }

    @EventHandler
    public void experience(PlayerUpdateExperienceEvent playerUpdateExperienceEvent) {
        this.update(playerUpdateExperienceEvent.getPlayer(), ProvidedListener.EXP);
    }

    @EventHandler
    public void respawn(PlayerRespawnEvent playerRespawnEvent) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)HappyHUD.getInstance(), () -> this.updateAll(playerRespawnEvent.getPlayer()), 2L);
    }

    private void update(Player player, LayerListener ... layerListenerArray) {
        if (HudHolder.has(player)) {
            HudHolder.get(player).update(layerListenerArray);
        }
    }

    private void updateAll(Player player) {
        if (HudHolder.has(player)) {
            HudHolder.get(player).update(new LayerListener[0]);
        }
    }

    private void forceSend(Player player) {
        if (HudHolder.has(player)) {
            HudHolder.get(player).send();
        }
    }
}

