/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.happyhud.api.hud;

import com.ehhthan.happyhud.HappyHUD;
import com.ehhthan.happyhud.api.HudHolder;
import com.ehhthan.happyhud.api.hud.condition.ConditionHolder;
import com.ehhthan.happyhud.api.hud.condition.Conditional;
import com.ehhthan.happyhud.api.hud.layer.Functional;
import com.ehhthan.happyhud.api.hud.layer.HudLayer;
import com.ehhthan.happyhud.comp.parser.Parser;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.lang.invoke.CallSite;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Matcher;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HudAsset
implements Parser,
Conditional {
    private final String key;
    private final Map<String, HudLayer> layers = new LinkedHashMap<String, HudLayer>();
    private final Map<String, Function<HudHolder, String>> placeholders;
    private final ConditionHolder conditions;

    public HudAsset(ConfigurationSection configurationSection) {
        this.key = configurationSection.getName().toLowerCase(Locale.ROOT);
        Preconditions.checkArgument((boolean)configurationSection.isConfigurationSection("layers"), (String)"No layers defined: %s", (Object)this.key);
        ConfigurationSection configurationSection2 = configurationSection.getConfigurationSection("layers");
        Set set = configurationSection2.getKeys(false);
        HashMap<CallSite, Function<HudHolder, String>> hashMap = new HashMap<CallSite, Function<HudHolder, String>>();
        int n = set.size();
        for (String string : set) {
            try {
                HudLayer hudLayer = HudLayer.get(this, configurationSection2.getConfigurationSection(string), n--);
                this.layers.put(string.toLowerCase(Locale.ROOT), hudLayer);
                if (!(hudLayer instanceof Functional)) continue;
                Functional functional = (Functional)((Object)hudLayer);
                for (Map.Entry<String, Function<HudHolder, String>> entry : functional.getListener().getPlaceholders().entrySet()) {
                    hashMap.put((CallSite)((Object)(hudLayer.getKey() + "-" + entry.getKey())), entry.getValue());
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                HappyHUD.getInstance().getLogger().log(Level.WARNING, String.format("Could not load layer '%s' from asset '%s': %s", string, this.key, illegalArgumentException.getMessage()));
            }
        }
        this.placeholders = Collections.unmodifiableMap(hashMap);
        this.conditions = new ConditionHolder(this, configurationSection.getStringList("conditions"));
    }

    public String getKey() {
        return this.key;
    }

    public Collection<HudLayer> getLayers() {
        return Lists.reverse(List.copyOf(this.layers.values()));
    }

    public boolean isLayer(String string) {
        if (string != null) {
            return this.layers.containsKey(string.toLowerCase(Locale.ROOT));
        }
        return false;
    }

    @Nullable
    public HudLayer getLayer(String string) {
        if (string != null) {
            return this.layers.get(string.toLowerCase(Locale.ROOT));
        }
        return null;
    }

    @Override
    public String parse(@NotNull HudHolder hudHolder, @NotNull String string) {
        for (Map.Entry<String, Function<HudHolder, String>> entry : this.placeholders.entrySet()) {
            String string2 = Matcher.quoteReplacement("%" + entry.getKey() + "%");
            String string3 = (String)entry.getValue().apply((Object)hudHolder);
            if (string2 == null || string3 == null) continue;
            string = string.replace(string2, string3);
        }
        return string;
    }

    @Override
    public ConditionHolder getConditions() {
        return this.conditions;
    }
}

