/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.happyhud.api.hud;

import com.ehhthan.happyhud.api.hud.condition.ConditionOperation;
import com.ehhthan.happyhud.api.util.MathUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HudLineConfig {
    private static final Pattern CONFIG_PATTERN = Pattern.compile("(?<key>\\w+) *\\{(?<args>\\S*)} *(?<match>true|false)? *(?<action>\\S+)? *(?<variable>\\S+)?");
    private final String key;
    private final Map<String, String> args;
    private final boolean match;
    private final String action;
    private final String variable;

    private HudLineConfig(@NotNull String string, @NotNull Map<String, String> map, boolean bl, @Nullable String string2, @Nullable String string3) {
        this.key = string.toLowerCase(Locale.ROOT);
        this.args = map;
        this.match = bl;
        this.action = string2;
        this.variable = string3;
    }

    public static HudLineConfig of(String string) {
        Matcher matcher = CONFIG_PATTERN.matcher(string);
        if (matcher.find()) {
            String string2 = matcher.group("key");
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (String string3 : matcher.group("args").split(" *; *")) {
                String[] stringArray = string3.split("=", 2);
                if (stringArray.length != 2) continue;
                hashMap.put(stringArray[0], stringArray[1]);
            }
            boolean bl = matcher.group("match") != null && matcher.group("match").equalsIgnoreCase("true");
            String string4 = matcher.group("action");
            String string5 = matcher.group("variable");
            return new HudLineConfig(string2, hashMap, bl, string4, string5);
        }
        throw new IllegalArgumentException("Invalid line config");
    }

    public String getKey() {
        return this.key;
    }

    public boolean isArg(String ... stringArray) {
        for (String string : stringArray) {
            if (!this.args.containsKey(string)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public String getString(String ... stringArray) {
        for (String string : stringArray) {
            if (!this.args.containsKey(string)) continue;
            return this.args.get(string);
        }
        return null;
    }

    @NotNull
    public String getString(String[] stringArray, @NotNull String string) {
        String string2 = this.getString(stringArray);
        return string2 != null ? string2 : string;
    }

    public Double getDouble(String ... stringArray) {
        for (String string : stringArray) {
            Optional<Double> optional;
            if (!this.args.containsKey(string) || !(optional = MathUtil.toDouble(this.args.get(string))).isPresent()) continue;
            return optional.get();
        }
        return null;
    }

    public double getDouble(String[] stringArray, double d) {
        Double d2 = this.getDouble(stringArray);
        return d2 != null ? d2 : d;
    }

    public String[] getStringList(String ... stringArray) {
        for (String string : stringArray) {
            if (!this.args.containsKey(string)) continue;
            return this.args.get(string).split(" *, *");
        }
        return null;
    }

    public String[] getStringList(String[] stringArray, String[] stringArray2) {
        String[] stringArray3 = this.getStringList(stringArray);
        return stringArray3 != null ? stringArray3 : stringArray2;
    }

    public ConditionOperation getOperation() {
        return ConditionOperation.of(this.getString("o", "oper", "operation"));
    }

    public boolean getMatch() {
        return this.match;
    }

    @Nullable
    public String getAction() {
        return this.action;
    }

    @Nullable
    public String getVariable() {
        return this.variable;
    }
}

