/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.happyhud.api.hud.active.element;

import com.ehhthan.happyhud.api.HudHolder;
import com.ehhthan.happyhud.api.element.layout.HudElement;
import com.ehhthan.happyhud.api.hud.active.ActiveParent;
import com.ehhthan.happyhud.api.hud.active.element.ActiveElementHolder;
import com.ehhthan.happyhud.api.hud.active.layer.ActiveLayer;
import com.ehhthan.happyhud.api.hud.condition.ConditionHolder;
import com.ehhthan.happyhud.api.hud.layer.HudLayer;
import com.ehhthan.happyhud.api.hud.layer.listener.LayerListener;
import com.ehhthan.happyhud.api.hud.layer.type.texture.TextureLayer;
import com.ehhthan.happyhud.api.resourcepack.component.RelativeWidth;
import com.ehhthan.libraries.kyori.adventure.text.Component;
import com.ehhthan.libraries.kyori.adventure.text.TextComponent;
import java.util.LinkedList;
import java.util.List;

public class ActiveElement
implements ActiveParent<HudElement> {
    private final ActiveElementHolder<?> elementHolder;
    private final HudElement element;
    private final String[] args;
    private final List<ActiveLayer<?>> layers = new LinkedList();
    private ConditionHolder.ConditionResult conditionResult;
    private Component component;

    public ActiveElement(ActiveElementHolder<?> activeElementHolder, HudElement hudElement, String ... stringArray) {
        this.elementHolder = activeElementHolder;
        this.element = hudElement;
        this.args = stringArray;
        for (HudLayer hudLayer : hudElement.getAsset().getLayers()) {
            this.layers.add(ActiveLayer.getLayer(this, hudLayer));
        }
        this.update(new LayerListener[0]);
    }

    @Override
    public HudHolder getHolder() {
        return this.elementHolder.getHolder();
    }

    @Override
    public HudElement getParent() {
        return this.element;
    }

    public String[] getArgs() {
        return this.args;
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    public ConditionHolder.ConditionResult getConditionResult() {
        return this.conditionResult;
    }

    @Override
    public boolean update(LayerListener ... layerListenerArray) {
        boolean bl = false;
        ConditionHolder.ConditionResult conditionResult = this.getParent().getAsset().getConditions().result(this.getHolder());
        if (conditionResult != this.conditionResult) {
            this.conditionResult = conditionResult;
            bl = true;
        }
        for (ActiveLayer<?> activeLayer : this.layers) {
            if (!activeLayer.update(layerListenerArray)) continue;
            bl = true;
        }
        if (bl) {
            this.build();
        }
        return bl;
    }

    @Override
    public void build() {
        TextComponent.Builder builder = Component.text();
        RelativeWidth relativeWidth = null;
        for (ActiveLayer<?> activeLayer : this.layers) {
            if (activeLayer.getConditionResult().isHidden()) continue;
            builder.append(activeLayer.getComponent());
            if (!(activeLayer.getLayer() instanceof TextureLayer)) continue;
            RelativeWidth relativeWidth2 = activeLayer.getSizedComponent().getRelativeWidth();
            relativeWidth = relativeWidth != null ? relativeWidth.merge(relativeWidth2) : relativeWidth2;
        }
        this.component = this.getParent().getAlignment().relativeAlign((Component)builder.build(), relativeWidth).color(this.conditionResult.getColor());
    }
}

