/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.happyhud.api.hud.active.layer;

import com.ehhthan.happyhud.api.HudHolder;
import com.ehhthan.happyhud.api.hud.active.Updatable;
import com.ehhthan.happyhud.api.hud.active.element.ActiveElement;
import com.ehhthan.happyhud.api.hud.active.layer.TextActiveLayer;
import com.ehhthan.happyhud.api.hud.active.layer.TextureActiveLayer;
import com.ehhthan.happyhud.api.hud.condition.ConditionHolder;
import com.ehhthan.happyhud.api.hud.layer.HudLayer;
import com.ehhthan.happyhud.api.hud.layer.type.text.TextLayer;
import com.ehhthan.happyhud.api.hud.layer.type.texture.TextureLayer;
import com.ehhthan.happyhud.api.resourcepack.component.SizedComponent;
import org.jetbrains.annotations.NotNull;

public interface ActiveLayer<T extends HudLayer>
extends Updatable {
    public HudHolder getHolder();

    public T getLayer();

    @NotNull
    public SizedComponent getSizedComponent();

    public ConditionHolder.ConditionResult getConditionResult();

    public static ActiveLayer<?> getLayer(ActiveElement element, HudLayer layer) {
        if (layer instanceof TextureLayer) {
            TextureLayer textureLayer = (TextureLayer)layer;
            return new TextureActiveLayer(element, textureLayer);
        }
        if (layer instanceof TextLayer) {
            TextLayer textLayer = (TextLayer)layer;
            return new TextActiveLayer(element, textLayer);
        }
        throw new IllegalArgumentException("Unknown layer type.");
    }
}

