/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.happyhud.api.hud.condition.type;

import com.ehhthan.happyhud.api.HudHolder;
import com.ehhthan.happyhud.api.hud.HudLineConfig;
import com.ehhthan.happyhud.api.hud.condition.AbstractHudCondition;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.bukkit.GameMode;

public class GamemodeCondition
extends AbstractHudCondition {
    private final List<GameMode> gamemodes = new ArrayList<GameMode>();

    public GamemodeCondition(HudLineConfig hudLineConfig) {
        super(hudLineConfig);
        String[] stringArray = hudLineConfig.getStringList("gm", "gamemode", "gamemodes");
        Preconditions.checkNotNull((Object)stringArray, (Object)"Gamemodes do not exist.");
        for (String string : stringArray) {
            this.gamemodes.add(GameMode.valueOf((String)string.toUpperCase(Locale.ROOT)));
        }
    }

    @Override
    public boolean conditionResult(HudHolder hudHolder) {
        return this.gamemodes.contains(hudHolder.player().getGameMode());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        GamemodeCondition gamemodeCondition = (GamemodeCondition)object;
        return this.gamemodes.equals(gamemodeCondition.gamemodes);
    }

    public int hashCode() {
        return Objects.hash(this.gamemodes);
    }
}

