/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.happyhud.api.hud.condition.type;

import com.ehhthan.happyhud.HappyHUD;
import com.ehhthan.happyhud.api.HudHolder;
import com.ehhthan.happyhud.api.hud.HudAsset;
import com.ehhthan.happyhud.api.hud.HudLineConfig;
import com.ehhthan.happyhud.api.hud.condition.AbstractHudCondition;
import com.ehhthan.happyhud.api.hud.condition.ConditionOperation;
import com.ehhthan.happyhud.api.util.MathUtil;
import com.google.common.base.Preconditions;
import java.util.Optional;

public class PlaceholderCondition
extends AbstractHudCondition {
    private final HudAsset asset;
    private final String placeholder;
    private final String value;
    private final ConditionOperation operation;

    public PlaceholderCondition(HudLineConfig hudLineConfig, HudAsset hudAsset) {
        super(hudLineConfig);
        this.asset = hudAsset;
        this.placeholder = hudLineConfig.getString("1", "ph", "placeholder");
        Preconditions.checkNotNull((Object)this.placeholder, (Object)"Placeholder does not exist.");
        this.value = hudLineConfig.getString("2", "v", "val", "value");
        this.operation = hudLineConfig.getOperation();
    }

    @Override
    public boolean conditionResult(HudHolder hudHolder) {
        String string = this.parse(hudHolder, this.placeholder);
        if (this.value == null) {
            return string.equalsIgnoreCase("true");
        }
        String string2 = this.parse(hudHolder, this.value);
        Optional<Double> optional = MathUtil.toDouble(string);
        Optional<Double> optional2 = MathUtil.toDouble(string2);
        if (optional.isPresent() && optional2.isPresent()) {
            return this.operation.evaluate(optional.get(), optional2.get());
        }
        return string.equalsIgnoreCase(string2);
    }

    private String parse(HudHolder hudHolder, String string) {
        return HappyHUD.getInstance().parsers().parse(hudHolder, this.asset.parse(hudHolder, string));
    }
}

