/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.happyhud.api.hud.layer;

import com.ehhthan.happyhud.HappyHUD;
import com.ehhthan.happyhud.api.hud.HudAsset;
import com.ehhthan.happyhud.api.hud.condition.Conditional;
import com.ehhthan.happyhud.api.hud.layer.LayerScale;
import com.ehhthan.happyhud.api.hud.layer.type.text.FunctionalTextLayer;
import com.ehhthan.happyhud.api.hud.layer.type.text.StaticTextLayer;
import com.ehhthan.happyhud.api.hud.layer.type.texture.FunctionalTextureLayer;
import com.ehhthan.happyhud.api.hud.layer.type.texture.StaticTextureLayer;
import com.ehhthan.happyhud.api.hud.util.HudAlignment;
import com.ehhthan.happyhud.api.resourcepack.asset.position.OffsetPosition;
import org.bukkit.configuration.ConfigurationSection;

public interface HudLayer
extends Conditional {
    public String getKey();

    public HudAsset getAsset();

    public OffsetPosition getOffset();

    public HudAlignment getAlignment();

    public LayerScale getScale();

    public boolean isScale();

    public boolean isOutlined();

    public static HudLayer get(HudAsset asset, ConfigurationSection section, int layerId) {
        if (section.isConfigurationSection("texture")) {
            if (section.isConfigurationSection("function")) {
                return new FunctionalTextureLayer(asset, section, layerId);
            }
            return new StaticTextureLayer(asset, section, layerId);
        }
        if (section.isSet("text")) {
            if (HappyHUD.getInstance().parsers().hasPlaceholder(section.getString("text", ""))) {
                return new FunctionalTextLayer(asset, section, layerId);
            }
            return new StaticTextLayer(asset, section, layerId);
        }
        throw new IllegalArgumentException("Invalid config section.");
    }
}

