/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.happyhud.api.resourcepack.asset.font.provider;

import com.ehhthan.happyhud.api.resourcepack.asset.font.CharacterSprite;
import com.ehhthan.happyhud.api.resourcepack.asset.font.provider.AbstractPackProvider;
import com.ehhthan.happyhud.api.resourcepack.asset.position.OffsetPosition;
import com.ehhthan.happyhud.api.resourcepack.texture.SizedImage;
import com.ehhthan.happyhud.api.resourcepack.texture.file.TextureFile;
import com.ehhthan.happyhud.api.resourcepack.texture.file.TiledTexture;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;

public class BitmapPackProvider
extends AbstractPackProvider {
    private final OffsetPosition offset;
    private final TiledTexture texture;
    private final JsonObject provider = new JsonObject();
    private final Map<Integer, CharacterSprite> sprites = new HashMap<Integer, CharacterSprite>();

    public BitmapPackProvider(ConfigurationSection configurationSection) {
        super(configurationSection);
        int n;
        this.offset = new OffsetPosition(0, configurationSection.getInt("ascent", 0), 0);
        int n2 = configurationSection.getInt("height", 8);
        List list = configurationSection.getStringList("chars");
        JsonArray jsonArray = new JsonArray();
        for (String string : list) {
            jsonArray.add(string);
        }
        Object object = new int[list.size()][];
        for (n = 0; n < list.size(); ++n) {
            object[n] = ((String)list.get(n)).codePoints().toArray();
        }
        n = ((Object)object).length;
        int n3 = ((Object)object[0]).length;
        this.texture = TextureFile.tiled(configurationSection.getString("texture", ""), n, n3);
        SizedImage[][] sizedImageArray = this.texture.getTiles();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n3; ++j) {
                Object object2 = object[i][j];
                SizedImage sizedImage = sizedImageArray[i][j];
                if (object2 == false || sizedImage == null) continue;
                double d = (double)n2 / (double)this.texture.getTileHeight();
                int n4 = (int)Math.round((double)(sizedImage.getX() + sizedImage.getWidth()) * d);
                this.sprites.put((int)object2, new CharacterSprite((int)object2, n4));
            }
        }
        this.provider.addProperty("type", "bitmap");
        this.provider.addProperty("file", "happyhud:font/" + this.texture.getPath());
        this.provider.addProperty("height", (Number)n2);
        this.provider.add("chars", (JsonElement)jsonArray);
    }

    public OffsetPosition getOffset() {
        return this.offset;
    }

    public TiledTexture getTexture() {
        return this.texture;
    }

    public JsonObject getProvider() {
        return this.provider;
    }

    @Override
    public Map<Integer, CharacterSprite> getSprites() {
        return this.sprites;
    }
}

