/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.happyhud.api.resourcepack.asset.font.provider;

import com.ehhthan.happyhud.api.resourcepack.asset.font.CharacterSprite;
import com.ehhthan.happyhud.api.resourcepack.asset.font.provider.BitmapPackProvider;
import com.ehhthan.happyhud.api.resourcepack.asset.font.provider.LegacyUnicodeProvider;
import com.ehhthan.happyhud.api.resourcepack.asset.font.provider.SpacePackProvider;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;

public interface PackProvider {
    public String getKey();

    public Map<Integer, CharacterSprite> getSprites();

    public static PackProvider get(ConfigurationSection section) throws IOException {
        ProviderType type = ProviderType.valueOf(section.getString("type", "BITMAP").toUpperCase(Locale.ROOT));
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case ProviderType.BITMAP -> new BitmapPackProvider(section);
            case ProviderType.SPACE -> new SpacePackProvider(section);
            case ProviderType.LEGACY_UNICODE -> new LegacyUnicodeProvider(section);
        };
    }

    public static enum ProviderType {
        BITMAP,
        SPACE,
        LEGACY_UNICODE;

    }
}

