/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.happyhud.api.resourcepack.asset.position;

import com.ehhthan.happyhud.api.resourcepack.asset.position.OffsetPosition;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;

public class ScreenPosition {
    private final float relativeX;
    private final float relativeY;
    private final OffsetPosition offset;

    public ScreenPosition(float f, float f2, OffsetPosition offsetPosition) {
        this.relativeX = new BigDecimal(f).setScale(1, RoundingMode.HALF_UP).floatValue();
        this.relativeY = new BigDecimal(f2).setScale(1, RoundingMode.HALF_UP).floatValue();
        this.offset = offsetPosition != null ? offsetPosition : OffsetPosition.EMPTY;
    }

    public ScreenPosition mergeOffset(OffsetPosition ... offsetPositionArray) {
        OffsetPosition offsetPosition = this.offset;
        for (OffsetPosition offsetPosition2 : offsetPositionArray) {
            if (offsetPosition2 == null || offsetPosition2 == OffsetPosition.EMPTY) continue;
            offsetPosition = offsetPosition.merge(offsetPosition2);
        }
        return new ScreenPosition(this.relativeX, this.relativeY, offsetPosition);
    }

    public OffsetPosition getOffset() {
        return this.offset;
    }

    public float getRelativeX() {
        return this.relativeX;
    }

    public float getRelativeY() {
        return this.relativeY;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ScreenPosition screenPosition = (ScreenPosition)object;
        if (Float.compare(screenPosition.relativeX, this.relativeX) != 0) {
            return false;
        }
        if (Float.compare(screenPosition.relativeY, this.relativeY) != 0) {
            return false;
        }
        return Objects.equals(this.offset, screenPosition.offset);
    }

    public int hashCode() {
        int n = this.relativeX != 0.0f ? Float.floatToIntBits(this.relativeX) : 0;
        n = 31 * n + (this.relativeY != 0.0f ? Float.floatToIntBits(this.relativeY) : 0);
        n = 31 * n + (this.offset != null ? this.offset.hashCode() : 0);
        return n;
    }
}

