/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.happyhud.api.resourcepack.builder;

public interface Incrementable<T> {
    public T next();

    public T start();

    public void reset();

    public static Incrementable<Character> character(final char c) {
        return new Incrementable<Character>(){
            private final char start;
            private char character;
            {
                this.start = c;
                this.character = c;
            }

            @Override
            public Character next() {
                char c2 = this.character;
                this.character = (char)(c2 + '\u0001');
                return Character.valueOf(c2);
            }

            @Override
            public Character start() {
                return Character.valueOf(this.start);
            }

            @Override
            public void reset() {
                this.character = this.start;
            }
        };
    }

    public static Incrementable<Integer> integer(final int i) {
        return new Incrementable<Integer>(){
            private final int start;
            private int integer;
            {
                this.start = i;
                this.integer = i;
            }

            @Override
            public Integer next() {
                return this.integer++;
            }

            @Override
            public Integer start() {
                return this.start;
            }

            @Override
            public void reset() {
                this.integer = this.start;
            }
        };
    }
}

