/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.happyhud.api.util;

import com.ehhthan.libraries.kyori.adventure.text.Component;
import com.ehhthan.libraries.kyori.adventure.text.TextComponent;
import com.ehhthan.libraries.kyori.adventure.text.format.NamedTextColor;
import com.ehhthan.libraries.kyori.adventure.text.format.TextColor;
import com.ehhthan.libraries.kyori.adventure.text.format.TextDecoration;
import com.ehhthan.libraries.kyori.adventure.text.minimessage.MiniMessage;
import com.ehhthan.libraries.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import java.util.Locale;

public class ComponentUtil {
    private static final LegacyComponentSerializer LEGACY_SERIALIZER = LegacyComponentSerializer.builder().character('\u00a7').useUnusualXRepeatedCharacterHexFormat().build();
    private static final MiniMessage MINI_MESSAGE = MiniMessage.miniMessage();

    public static TextColor color(String string) {
        if (string != null) {
            if (TextColor.fromHexString(string = string.toLowerCase(Locale.ROOT).replace(" ", "_").replace("-", "_")) != null) {
                return TextColor.fromHexString(string);
            }
            if (NamedTextColor.NAMES.keys().contains(string)) {
                return NamedTextColor.NAMES.value(string);
            }
        }
        throw new IllegalArgumentException("Color does not exist: " + (string != null ? string : "null"));
    }

    public static TextComponent stripFont(Component component) {
        TextComponent textComponent = ComponentUtil.toTextComponent(component);
        return (TextComponent)((TextComponent.Builder)((TextComponent.Builder)textComponent.toBuilder()).applyDeep(componentBuilder -> componentBuilder.font(null))).build();
    }

    public static TextComponent stripItalic(Component component) {
        TextComponent textComponent = ComponentUtil.toTextComponent(component);
        return (TextComponent)((TextComponent.Builder)((TextComponent.Builder)textComponent.toBuilder()).applyDeep(componentBuilder -> componentBuilder.decoration(TextDecoration.ITALIC, TextDecoration.State.NOT_SET))).build();
    }

    public static String serialize(Component component) {
        String string = (String)MINI_MESSAGE.serialize(component);
        return string.replace("\\<", "<");
    }

    public static String fromLegacy(String string) {
        return ComponentUtil.serialize(LEGACY_SERIALIZER.deserialize(string));
    }

    public static Component fromLegacyComponent(Component component) {
        return MINI_MESSAGE.deserialize(ComponentUtil.fromLegacy(ComponentUtil.serialize(component)));
    }

    private static TextComponent toTextComponent(Component component) {
        return (TextComponent)((TextComponent.Builder)Component.text().append(component)).build();
    }
}

