/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.happyhud.comp.protocollib;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.wrappers.WrappedAttribute;
import com.ehhthan.happyhud.HappyHUD;
import com.ehhthan.happyhud.api.HudHolder;
import com.ehhthan.happyhud.api.bossbar.BossBarHandler;
import com.ehhthan.happyhud.api.event.PlayerUpdateAttributeEvent;
import com.ehhthan.happyhud.api.event.PlayerUpdateConsumableEvent;
import com.ehhthan.happyhud.api.event.PlayerUpdateExperienceEvent;
import com.ehhthan.happyhud.comp.protocollib.wrapper.WrapperPlayServerBoss;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class ProtocolLibSupport {
    private final HappyHUD happyHUD;

    public ProtocolLibSupport(HappyHUD happyHUD) {
        this.happyHUD = happyHUD;
        this.register();
    }

    public void reload() {
    }

    private void register() {
        ProtocolManager protocolManager = ProtocolLibrary.getProtocolManager();
        protocolManager.addPacketListener((PacketListener)new PacketAdapter((Plugin)this.happyHUD, ListenerPriority.HIGHEST, new PacketType[]{PacketType.Play.Server.UPDATE_HEALTH}){

            public void onPacketSending(PacketEvent packetEvent) {
                Bukkit.getPluginManager().callEvent((Event)new PlayerUpdateConsumableEvent(packetEvent.getPlayer()));
            }
        });
        protocolManager.addPacketListener((PacketListener)new PacketAdapter((Plugin)this.happyHUD, ListenerPriority.HIGHEST, new PacketType[]{PacketType.Play.Server.UPDATE_ATTRIBUTES}){

            public void onPacketSending(PacketEvent packetEvent) {
                Iterator iterator = packetEvent.getPacket().getEntityModifier(packetEvent).read(0);
                if (iterator instanceof Player) {
                    Player player = (Player)iterator;
                    for (WrappedAttribute wrappedAttribute : (List)packetEvent.getPacket().getAttributeCollectionModifier().read(0)) {
                        Attribute attribute = ProtocolLibSupport.attributeFromKey(wrappedAttribute);
                        if (attribute == null) continue;
                        Bukkit.getPluginManager().callEvent((Event)new PlayerUpdateAttributeEvent(player, attribute));
                    }
                }
            }
        });
        protocolManager.addPacketListener((PacketListener)new PacketAdapter((Plugin)this.happyHUD, ListenerPriority.HIGHEST, new PacketType[]{PacketType.Play.Server.EXPERIENCE}){

            public void onPacketSending(PacketEvent packetEvent) {
                Bukkit.getPluginManager().callEvent((Event)new PlayerUpdateExperienceEvent(packetEvent.getPlayer()));
            }
        });
        protocolManager.addPacketListener((PacketListener)new PacketAdapter((Plugin)this.happyHUD, ListenerPriority.HIGHEST, new PacketType[]{PacketType.Play.Server.BOSS}){

            public void onPacketSending(PacketEvent packetEvent) {
                if (HudHolder.has(packetEvent.getPlayer())) {
                    UUID uUID = (UUID)packetEvent.getPacket().getUUIDs().readSafely(0);
                    BossBarHandler bossBarHandler = HudHolder.get(packetEvent.getPlayer()).getBarHandler();
                    if (!bossBarHandler.isHolding(uUID)) {
                        packetEvent.setCancelled(true);
                        bossBarHandler.send(new WrapperPlayServerBoss(packetEvent.getPacket()));
                    }
                }
            }
        });
    }

    private static Attribute attributeFromKey(WrappedAttribute wrappedAttribute) {
        Attribute attribute = null;
        try {
            attribute = Attribute.valueOf((String)wrappedAttribute.getAttributeKey().replace('.', '_').toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return attribute;
    }
}

