/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.happyhud.file;

import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;

public class CopyFileVisitor
extends SimpleFileVisitor<Path> {
    private final Path targetPath;
    private Path sourcePath = null;

    public CopyFileVisitor(Path path) {
        this.targetPath = path;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) {
        if (this.sourcePath == null) {
            this.sourcePath = path;
        } else {
            Files.createDirectories(this.targetPath.resolve(this.sourcePath.relativize(path)), new FileAttribute[0]);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) {
        Files.copy(path, this.targetPath.resolve(this.sourcePath.relativize(path)), StandardCopyOption.REPLACE_EXISTING);
        return FileVisitResult.CONTINUE;
    }
}

