/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.happyhud.file;

import com.ehhthan.happyhud.HappyHUD;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class FileVersion {
    private static final Map<File, UpdatableFile> FILES = new HashMap<File, UpdatableFile>();

    private FileVersion() {
    }

    public static boolean check(File file) {
        return FILES.containsKey(file) && FILES.get(file).isOutdated();
    }

    static {
        UpdatableFile updatableFile = new UpdatableFile("pack/minecraft/shaders/core/rendertype_text.vsh", Pattern.compile("#define *HH_VERSION *([0-9]*)"), 3);
        FILES.put(updatableFile.file, updatableFile);
    }

    private static final class UpdatableFile {
        private final Pattern pattern;
        private final int currentVersion;
        private final File file;

        private UpdatableFile(String string, Pattern pattern, int n) {
            this.pattern = pattern;
            this.currentVersion = n;
            this.file = new File(HappyHUD.getInstance().getDataFolder(), string);
        }

        private boolean isOutdated() {
            if (this.file.exists()) {
                Scanner scanner;
                try {
                    scanner = new Scanner(this.file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return false;
                }
                while (scanner.hasNextLine()) {
                    String string = scanner.nextLine();
                    Matcher matcher = this.pattern.matcher(string);
                    if (!matcher.matches()) continue;
                    scanner.close();
                    return Integer.parseInt(matcher.group(1)) < this.currentVersion;
                }
                scanner.close();
                return true;
            }
            return false;
        }
    }
}

